/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cactus.integration.ant.container.resin;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.apache.cactus.integration.ant.container.AbstractServerRun;

public class ResinRun
extends AbstractServerRun {
    private Object resinServer;
    static /* synthetic */ Class class$java$util$ArrayList;
    static /* synthetic */ Class array$Ljava$lang$String;

    public ResinRun(String[] theArgs) {
        super(theArgs);
    }

    public static void main(String[] theArgs) {
        ResinRun resin = new ResinRun(theArgs);
        resin.doRun();
    }

    protected final Thread doStartServer(String[] theArgs) {
        Thread runningThread;
        block5: {
            runningThread = this;
            try {
                if (this.isResinVersion("2.0")) {
                    this.startResin20x(theArgs);
                    break block5;
                }
                if (this.isResinVersion("2.1")) {
                    this.startResin21x(theArgs);
                    break block5;
                }
                if (this.isResinVersion("3")) {
                    runningThread = this.startResin3x(theArgs);
                    break block5;
                }
                throw new RuntimeException("Unsupported Resin version [" + this.getResinVersion() + "]");
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new RuntimeException("Failed to start Resin server");
            }
        }
        return runningThread;
    }

    private void startResin20x(String[] theArgs) throws Exception {
        Class<?> resinClass = Class.forName("com.caucho.server.http.ResinServer");
        Constructor<?> constructor = resinClass.getConstructor(theArgs.getClass(), Boolean.TYPE);
        this.resinServer = constructor.newInstance(theArgs, Boolean.TRUE);
        Method initMethod = this.resinServer.getClass().getMethod("init", Boolean.TYPE);
        initMethod.invoke(this.resinServer, Boolean.TRUE);
    }

    private void startResin21x(String[] theArgs) throws Exception {
        Class<?> resinClass = Class.forName("com.caucho.server.http.ResinServer");
        Constructor<?> constructor = resinClass.getConstructor(theArgs.getClass(), Boolean.TYPE);
        this.resinServer = constructor.newInstance(theArgs, Boolean.TRUE);
        Method initMethod = this.resinServer.getClass().getMethod("init", class$java$util$ArrayList == null ? (class$java$util$ArrayList = ResinRun.class$("java.util.ArrayList")) : class$java$util$ArrayList);
        initMethod.invoke(this.resinServer, new Object[]{null});
    }

    private Thread startResin3x(final String[] theArgs) throws Exception {
        Thread startThread = new Thread(){

            public void run() {
                try {
                    Class<?> resinClass = Class.forName("com.caucho.server.http.ResinServer");
                    Method mainMethod = resinClass.getMethod("main", array$Ljava$lang$String == null ? (array$Ljava$lang$String = ResinRun.class$("[Ljava.lang.String;")) : array$Ljava$lang$String);
                    mainMethod.invoke(null, new Object[]{theArgs});
                }
                catch (Exception e) {
                    e.printStackTrace();
                    throw new RuntimeException("Failed to start Resin 3.x. Error = [" + e.getMessage() + "]");
                }
            }
        };
        startThread.start();
        return startThread;
    }

    protected final void doStopServer(String[] theArgs, Thread theRunningServerThread) {
        block5: {
            try {
                if (this.isResinVersion("2.0")) {
                    this.stopResin20x(theArgs);
                    break block5;
                }
                if (this.isResinVersion("2.1")) {
                    this.stopResin20x(theArgs);
                    break block5;
                }
                if (this.isResinVersion("3")) {
                    this.stopResin3x(theArgs, theRunningServerThread);
                    break block5;
                }
                throw new RuntimeException("Unsupported Resin version [" + this.getResinVersion() + "]");
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new RuntimeException("Failed to stop the running Resin server");
            }
        }
    }

    private void stopResin20x(String[] theArgs) throws Exception {
        Method closeMethod = this.resinServer.getClass().getMethod("close", null);
        closeMethod.invoke(this.resinServer, null);
    }

    private void stopResin3x(String[] theArgs, Thread theRunningServerThread) throws Exception {
        theRunningServerThread.stop();
    }

    private String getResinVersion() {
        String version;
        try {
            Class<?> versionClass = Class.forName("com.caucho.Version");
            Field versionField = versionClass.getField("VERSION");
            version = (String)versionField.get(null);
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot get Resin version. Error = [" + e.getMessage() + "]");
        }
        return version;
    }

    private boolean isResinVersion(String theVersionPrefix) {
        return this.getResinVersion().startsWith(theVersionPrefix);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

