/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jsfunit.framework;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.cactus.internal.ServiceEnumeration;
import org.apache.cactus.internal.server.ServletUtil;
import org.apache.cactus.server.ServletTestRedirector;
import org.jboss.jsfunit.seam.SeamUtil;

public class JSFUnitServletRedirector
extends ServletTestRedirector {
    public void doPost(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException {
        super.doPost(httpServletRequest, httpServletResponse);
        this.cleanUp(httpServletRequest);
    }

    public void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException {
        super.doGet(httpServletRequest, httpServletResponse);
        this.cleanUp(httpServletRequest);
    }

    private void cleanUp(HttpServletRequest httpServletRequest) {
        HttpSession session;
        if (!this.isCallTestService(httpServletRequest)) {
            return;
        }
        if (SeamUtil.isSeamInitialized()) {
            SeamUtil.invalidateSeamSession(httpServletRequest);
        }
        if ((session = httpServletRequest.getSession(false)) != null) {
            session.invalidate();
        }
    }

    private boolean isCallTestService(HttpServletRequest httpServletRequest) {
        String queryString = httpServletRequest.getQueryString();
        String serviceName = ServletUtil.getQueryStringParameter((String)queryString, (String)"Cactus_Service");
        return ServiceEnumeration.valueOf((String)serviceName) == ServiceEnumeration.CALL_TEST_SERVICE;
    }
}

