/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jsfunit.seam;

import com.gargoylesoftware.htmlunit.WebRequestSettings;
import com.gargoylesoftware.htmlunit.WebResponse;
import java.util.Map;
import javax.faces.context.FacesContext;
import javax.servlet.http.HttpServletRequest;
import org.jboss.jsfunit.framework.FacesContextBridge;
import org.jboss.jsfunit.framework.RequestListener;
import org.jboss.seam.contexts.ServletLifecycle;
import org.jboss.seam.core.ConversationPropagation;
import org.jboss.seam.core.Manager;
import org.jboss.seam.servlet.ServletRequestSessionMap;
import org.jboss.seam.web.ServletContexts;

public class SeamRequestListener
implements RequestListener {
    private boolean iPromotedTheConversation = false;
    private boolean iRestoredTheConversation = false;

    public void beforeRequest(WebRequestSettings webRequestSettings) {
        this.demoteConversation();
        this.tearDownConversation();
    }

    public void afterRequest(WebResponse webResponse) {
        this.promoteConversation();
        this.restoreConversation();
    }

    private void restoreConversation() {
        HttpServletRequest request = this.httpServletRequest();
        if (request == null) {
            return;
        }
        ServletLifecycle.beginRequest((HttpServletRequest)request);
        ServletContexts.instance().setRequest(request);
        ConversationPropagation.instance().restoreConversationId(request.getParameterMap());
        Manager.instance().restoreConversation();
        ServletLifecycle.resumeConversation((HttpServletRequest)request);
        Manager.instance().handleConversationPropagation(request.getParameterMap());
        this.iRestoredTheConversation = true;
    }

    private void tearDownConversation() {
        if (!this.iRestoredTheConversation) {
            return;
        }
        HttpServletRequest request = this.httpServletRequest();
        Manager.instance().endRequest((Map)new ServletRequestSessionMap(request));
        ServletLifecycle.endRequest((HttpServletRequest)request);
        this.iRestoredTheConversation = false;
    }

    private void demoteConversation() {
        if (this.iPromotedTheConversation) {
            Manager.instance().setLongRunningConversation(false);
            this.iPromotedTheConversation = false;
        }
    }

    private void promoteConversation() {
        try {
            if (!Manager.instance().isLongRunningConversation()) {
                Manager.instance().setLongRunningConversation(true);
                this.iPromotedTheConversation = true;
            }
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    private HttpServletRequest httpServletRequest() {
        FacesContext facesContext = FacesContextBridge.getCurrentInstance();
        if (facesContext == null) {
            return null;
        }
        return (HttpServletRequest)facesContext.getExternalContext().getRequest();
    }
}

