// DatenobjektCollection.cpp: implementation of the CDatenobjektCollection class.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "ConstTest.h"
#include "DatenobjektCollection.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

CDatenobjektCollection::CDatenobjektCollection()
{

	this->listValues = new CTypedPtrList<CObList, CDatenobjekt *>();
}

CDatenobjektCollection::~CDatenobjektCollection()
{

}

/**Hinzufgen eines neuen Datenobjekts zur Collection.
 *
 */
void CDatenobjektCollection::AddDatenobjekt(CString str_Value)
{
	CDatenobjekt *datenobjekt = new CDatenobjekt();
	datenobjekt->SetValue (str_Value);

	this->listValues->AddTail (datenobjekt);
}

/**Konstante Methode zum abrufen des n-ten Objekts aus der Collection.
 * Das so erzeugte Objekt ist ein konstanter Zeiger, d.h. es kann keine Methode des Objekts
 * aufgerufen werden, die NICHT als "const" deklariert ist.
 */
const CDatenobjekt * CDatenobjektCollection::GetDatenobjekt(int int_Index)
{

	CDatenobjekt *datenobjekt = this->listValues->GetAt (this->listValues->FindIndex (int_Index) );

	return (const CDatenobjekt *) datenobjekt;
}
