/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package de.hsrm.cs.swt.swingbasics2.combobox;

import java.util.Vector;
import javax.swing.DefaultComboBoxModel;

/**
 *
 * @author Wolfgang Knauf
 */
public class ComboBoxDialog extends javax.swing.JDialog {

    private boolean okClicked = false;

    /**
     * Creates new form ComboBoxDialog
     *
     * @param parent Parentfenster
     * @param modal Zeigt den Dialog modal an.
     */
    public ComboBoxDialog(java.awt.Frame parent, boolean modal) {
        super(parent, modal);
        initComponents();

        Vector<Student> listData = new Vector<Student>();
        Student stud1 = new Student();
        stud1.setMatrikelnummer(1234567);
        stud1.setVorname("Hans");
        stud1.setNachname("Meier");
        listData.add(stud1);

        Student stud2 = new Student();
        stud2.setMatrikelnummer(333444);
        stud2.setVorname("Sybille");
        stud2.setNachname("Müller");
        listData.add(stud2);

        Student stud3 = new Student();
        stud3.setMatrikelnummer(568923);
        stud3.setVorname("Otto");
        stud3.setNachname("Huber");
        listData.add(stud3);

        this.jComboBoxTest.setModel(new DefaultComboBoxModel<Student>(listData));
    }

    /**
     * This method is called from within the constructor to initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is always
     * regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        jComboBoxTest = new javax.swing.JComboBox<>();
        jButtonOK = new javax.swing.JButton();
        jButtonAbbrechen = new javax.swing.JButton();
        jLabelComboBox = new javax.swing.JLabel();
        jLabelSelected = new javax.swing.JLabel();
        jTextFieldSelected = new javax.swing.JTextField();

        setDefaultCloseOperation(javax.swing.WindowConstants.DISPOSE_ON_CLOSE);

        jComboBoxTest.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jComboBoxTestActionPerformed(evt);
            }
        });

        jButtonOK.setText("OK");
        jButtonOK.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonOKActionPerformed(evt);
            }
        });

        jButtonAbbrechen.setText("Abbrechen");
        jButtonAbbrechen.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonAbbrechenActionPerformed(evt);
            }
        });

        jLabelComboBox.setText("Studenten:");

        jLabelSelected.setText("Gewählt:");

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(getContentPane());
        getContentPane().setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, layout.createSequentialGroup()
                        .addContainerGap(248, Short.MAX_VALUE)
                        .addComponent(jButtonOK)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                        .addComponent(jButtonAbbrechen))
                    .addGroup(layout.createSequentialGroup()
                        .addGap(26, 26, 26)
                        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addComponent(jLabelComboBox)
                            .addComponent(jLabelSelected))
                        .addGap(46, 46, 46)
                        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addComponent(jTextFieldSelected)
                            .addComponent(jComboBoxTest, 0, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))))
                .addContainerGap())
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addGap(41, 41, 41)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jComboBoxTest, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(jLabelComboBox))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jLabelSelected)
                    .addComponent(jTextFieldSelected, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED, 172, Short.MAX_VALUE)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jButtonOK)
                    .addComponent(jButtonAbbrechen))
                .addContainerGap())
        );

        pack();
    }// </editor-fold>//GEN-END:initComponents

    private void jButtonOKActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonOKActionPerformed
        this.okClicked = true;
        this.setVisible(false);
    }//GEN-LAST:event_jButtonOKActionPerformed

    private void jButtonAbbrechenActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonAbbrechenActionPerformed
        this.okClicked = false;
        this.setVisible(false);
    }//GEN-LAST:event_jButtonAbbrechenActionPerformed

    private void jComboBoxTestActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jComboBoxTestActionPerformed
        //NULL abfangen.
        if (this.jComboBoxTest.getSelectedItem() != null)
        {
            this.jTextFieldSelected.setText (this.jComboBoxTest.getSelectedItem().toString());
        }
        else
        {
            this.jTextFieldSelected.setText ("--");
        }
    }//GEN-LAST:event_jComboBoxTestActionPerformed

    /**
     * Wurde der Dialog durch Klick auf den "OK"-Button geschlossen?
     *
     * @return true wenn auf OK geklickt wurde, false wenn auf "Abbrechen"
     * geklickt wurde oder noch keine der Aktionen erfolgte.
     */
    public boolean isOkClicked() {
        return this.okClicked;
    }

    /**
     * Liefert den aktuell in der Combobox gewählten Studenten - könnte NULL sein.
     *
     * @return Gewählter Student oder null.
     */
    public Student getEingabe() {
        return (Student) this.jComboBoxTest.getSelectedItem();
    }

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton jButtonAbbrechen;
    private javax.swing.JButton jButtonOK;
    private javax.swing.JComboBox<Student> jComboBoxTest;
    private javax.swing.JLabel jLabelComboBox;
    private javax.swing.JLabel jLabelSelected;
    private javax.swing.JTextField jTextFieldSelected;
    // End of variables declaration//GEN-END:variables
}
