/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package de.hsrm.cs.swt.swingbasics2.list;

import de.hsrm.cs.swt.swingbasics2.combobox.Student;
import de.hsrm.cs.swt.swingbasics2.dialog.*;
import java.util.List;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;

/**
 *
 * @author Wolfgang Knauf
 */
public class ListDialog extends javax.swing.JDialog {
    
    private boolean okClicked = false;

    /**
     * Creates new form ComboBoxDialog
     *
     * @param parent Parentfenster
     * @param modal Zeigt den Dialog modal an.
     */
    public ListDialog(java.awt.Frame parent, boolean modal) {
        super(parent, modal);
        initComponents();
        
        Vector<Student> listData = new Vector<Student>();
        Student stud1 = new Student();
        stud1.setMatrikelnummer(1234567);
        stud1.setVorname("Hans");
        stud1.setNachname("Meier");
        listData.add(stud1);
        
        Student stud2 = new Student();
        stud2.setMatrikelnummer(333444);
        stud2.setVorname("Sybille");
        stud2.setNachname("Müller");
        listData.add(stud2);
        
        Student stud3 = new Student();
        stud3.setMatrikelnummer(568923);
        stud3.setVorname("Otto");
        stud3.setNachname("Huber");
        listData.add(stud3);
        
        this.jListTest.setModel(new DefaultComboBoxModel<Student>(listData));
    }

    /**
     * This method is called from within the constructor to initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is always
     * regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        jButtonOK = new javax.swing.JButton();
        jButtonAbbrechen = new javax.swing.JButton();
        jLabelTest = new javax.swing.JLabel();
        jScrollPaneList = new javax.swing.JScrollPane();
        jListTest = new javax.swing.JList<>();
        jLabelSelected = new javax.swing.JLabel();
        jTextFieldSelected = new javax.swing.JTextField();

        setDefaultCloseOperation(javax.swing.WindowConstants.DISPOSE_ON_CLOSE);

        jButtonOK.setText("OK");
        jButtonOK.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonOKActionPerformed(evt);
            }
        });

        jButtonAbbrechen.setText("Abbrechen");
        jButtonAbbrechen.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonAbbrechenActionPerformed(evt);
            }
        });

        jLabelTest.setText("Auswahl:");

        jListTest.addListSelectionListener(new javax.swing.event.ListSelectionListener() {
            public void valueChanged(javax.swing.event.ListSelectionEvent evt) {
                jListTestValueChanged(evt);
            }
        });
        jScrollPaneList.setViewportView(jListTest);

        jLabelSelected.setText("Gewählt:");

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(getContentPane());
        getContentPane().setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, layout.createSequentialGroup()
                        .addContainerGap(248, Short.MAX_VALUE)
                        .addComponent(jButtonOK)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                        .addComponent(jButtonAbbrechen))
                    .addGroup(layout.createSequentialGroup()
                        .addGap(22, 22, 22)
                        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addGroup(layout.createSequentialGroup()
                                .addComponent(jLabelSelected)
                                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                                .addComponent(jTextFieldSelected))
                            .addGroup(layout.createSequentialGroup()
                                .addComponent(jLabelTest)
                                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                                .addComponent(jScrollPaneList)))))
                .addContainerGap())
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addGap(49, 49, 49)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(jLabelTest)
                    .addComponent(jScrollPaneList, javax.swing.GroupLayout.PREFERRED_SIZE, 100, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addGap(5, 5, 5)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jLabelSelected)
                    .addComponent(jTextFieldSelected, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED, 92, Short.MAX_VALUE)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jButtonOK)
                    .addComponent(jButtonAbbrechen))
                .addContainerGap())
        );

        pack();
    }// </editor-fold>//GEN-END:initComponents

    private void jButtonOKActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonOKActionPerformed
        this.okClicked = true;
        this.setVisible(false);
    }//GEN-LAST:event_jButtonOKActionPerformed

    private void jButtonAbbrechenActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonAbbrechenActionPerformed
        this.okClicked = false;
        this.setVisible(false);
    }//GEN-LAST:event_jButtonAbbrechenActionPerformed

    private void jListTestValueChanged(javax.swing.event.ListSelectionEvent evt) {//GEN-FIRST:event_jListTestValueChanged
        String selected = "";
        
        for (Student studentSel : this.jListTest.getSelectedValuesList()) {
            if (selected.length() > 0) {
                selected += ", ";
            }
            selected += studentSel.toString();
        }
        this.jTextFieldSelected.setText(selected);
        
    }//GEN-LAST:event_jListTestValueChanged

    /**
     * Wurde der Dialog durch Klick auf den "OK"-Button geschlossen?
     *
     * @return true wenn auf OK geklickt wurde, false wenn auf "Abbrechen"
     * geklickt wurde oder noch keine der Aktionen erfolgte.
     */
    public boolean isOkClicked() {
        return this.okClicked;
    }

    /**
     * Liefert die aktuelle Auswahl in der Studentenliste
     *
     * @return Auswahl in der Studentenliste
     */
    public List<Student> getAuswahl() {
        return this.jListTest.getSelectedValuesList();
    }

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton jButtonAbbrechen;
    private javax.swing.JButton jButtonOK;
    private javax.swing.JLabel jLabelSelected;
    private javax.swing.JLabel jLabelTest;
    private javax.swing.JList<Student> jListTest;
    private javax.swing.JScrollPane jScrollPaneList;
    private javax.swing.JTextField jTextFieldSelected;
    // End of variables declaration//GEN-END:variables
}
