package com.knauf.ejb.concurrency;

/**
 * Thread fr Zugriff auf CounterBean ber Stateful SessionBean.
 */
public class ConcurrencyThreadStatefulSession implements Runnable
{
	/**ConcurrencyTester-Bean */
	private ConcurrencyTesterStateful concurrencyTester = null;
	/**Eindeutige Kennung des Threads. */
	private String strKennung = null;
	/**Konstruktor.
	 * 
	 * @param _counter Die CounterBean, auf der gearbeitet wird.
	 * @param _strKennung Eine eindeutige Kennung, damit wir Bean-Ausgaben zuordnen knnen.
	 */
	public ConcurrencyThreadStatefulSession(
	ConcurrencyTesterStateful _concurrencyTester,
		String _strKennung)
	{
		this.concurrencyTester = _concurrencyTester;
		this.strKennung = _strKennung;
	}
	/**
	 * Thread ausfhren: Counter um 1 erhhen.
	 */
	public void run()
	{
		try
		{
			System.err.println(
				this.strKennung
					+ ":ConcurrentThread fr ConcurrencyTesterStateful-Bean gestartet");
			//Jetzt loslegen:
			this.concurrencyTester.incrementPessimisticUpdateExclusive(this.strKennung);
			//Wert erneut auslesen:
			System.err.println("Alles fertig !");
		}
		catch (Exception ex)
		{
			System.err.println(this.strKennung + ": Exception!");
			ex.printStackTrace();
		}
	}
}
