package com.knauf.ejb.concurrency;
/**Diese Klasse bernimmt bei Threadsteuerung die Logik.
 * Ruft Methode fr "OptimisticUpdate" auf.
 */
public class ConcurrentThreadOptimisticUpdate implements Runnable
{
	/**Counter-Bean */
	private Counter counter = null;
	/**Eindeutige Kennung des Threads. */
	private String strKennung = null;
	/**Konstruktor.
	 * 
	 * @param _counter Die CounterBean, auf der gearbeitet wird.
	 * @param _strKennung Eine eindeutige Kennung, damit wir Bean-Ausgaben zuordnen knnen.
	 */
	public ConcurrentThreadOptimisticUpdate(
		Counter _counter,
		String _strKennung)
	{
		this.counter = _counter;
		this.strKennung = _strKennung;
	}
	/**
	 * Thread ausfhren: Counter um 1 erhhen.
	 */
	public void run()
	{
		try
		{
			System.err.println(
				this.strKennung
					+ ":ConcurrentThread 'OptimisticUpdate' gestartet");
			//Jetzt loslegen:
			this.counter.incrementOptimisticUpdate(this.strKennung);
			//Wert erneut auslesen:
			System.err.println(
				this.strKennung + ":Counter ist: " + this.counter.getCount());
		}
		catch (Exception ex)
		{
			System.err.println(this.strKennung + ": Exception!");
			ex.printStackTrace();
		}
	}
}
