package com.knauf.ejb.concurrency;
import java.util.ConcurrentModificationException;
import javax.rmi.PortableRemoteObject;
import javax.ejb.EJBContext;
import javax.ejb.FinderException;
import javax.naming.InitialContext;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
/**
 * Hauptfenster des Concurrency-Tests.
 */
public class FrameConcurrency extends JFrame
{
	private javax.swing.JPanel jContentPane = null;
	private javax.swing.JButton btnGo = null;
	private CounterHome counterHome = null;
	private Counter counter = null;
	private ConcurrencyTesterStatelessHome concurrencyTesterStatelessHome =
		null;
	private ConcurrencyTesterStatefulHome concurrencyTesterStatefulHome = null;
	private javax.swing.JButton btnOptimisticUpdate = null;
	private javax.swing.JButton btnPessimisticUpdateWeakestLockAtLoad = null;
	private javax.swing.JButton jButtonPessimisticUpdateExclusive = null;
	private javax.swing.JButton jButtonStatefulSessionBean = null;
	private javax.swing.JButton jButtonStatefulSessionBeanThreads = null;
	private javax.swing.JButton btnStatelessSessionBean = null;
	private javax.swing.JButton btnStatelessSessionBeanThreads = null;
	/**Mainmethode.
	 * 
	 * @param args
	 */
	public static void main(String[] args)
	{
		FrameConcurrency frame = new FrameConcurrency();
		frame.show();
	}
	/**
	 * This is the default constructor
	 */
	public FrameConcurrency()
	{
		super();
		initialize();
		try
		{
			//Home-Interface holen:
			InitialContext initialContext = new InitialContext();
			Object homeref = initialContext.lookup("java:comp/env/ejb/Counter");
			this.counterHome =
				(CounterHome) PortableRemoteObject.narrow(
					homeref,
					CounterHome.class);
			//Gibt es die Bean mit der ID 100 schon ?
			this.counter = null;
			try
			{
				this.counter = counterHome.findByPrimaryKey(new Integer(100));
			}
			catch (FinderException fex)
			{
				//Bean existiert nicht: erzeugen.
				this.counter = counterHome.create(new Integer(100));
				//Und Startwert aus "1" setzen:
				this.counter.setCount(new Integer(1));
			}
			//Home-Interface holen:
			homeref =
				initialContext.lookup(
					"java:comp/env/ejb/ConcurrencyTesterStateful");
			this.concurrencyTesterStatefulHome =
				(ConcurrencyTesterStatefulHome) PortableRemoteObject.narrow(
					homeref,
					ConcurrencyTesterStatefulHome.class);
			//Home-Interface holen:
			homeref =
				initialContext.lookup(
					"java:comp/env/ejb/ConcurrencyTesterStateless");
			this.concurrencyTesterStatelessHome =
				(ConcurrencyTesterStatelessHome) PortableRemoteObject.narrow(
					homeref,
					ConcurrencyTesterStatelessHome.class);
		}
		catch (Exception ex)
		{
			ex.printStackTrace();
		}
	}
	/**
	 * This method initializes this
	 * 
	 * @return void
	 */
	private void initialize()
	{
		this.setSize(300, 239);
		this.setContentPane(getJContentPane());
		this.setDefaultCloseOperation(javax.swing.JFrame.EXIT_ON_CLOSE);
	}
	/**
	 * This method initializes jContentPane
	 * 
	 * @return javax.swing.JPanel
	 */
	private javax.swing.JPanel getJContentPane()
	{
		if (jContentPane == null)
		{
			jContentPane = new javax.swing.JPanel();
			java.awt.GridBagConstraints consGridBagConstraints2 =
				new java.awt.GridBagConstraints();
			java.awt.GridBagConstraints consGridBagConstraints1 =
				new java.awt.GridBagConstraints();
			java.awt.GridBagConstraints consGridBagConstraints3 =
				new java.awt.GridBagConstraints();
			java.awt.GridBagConstraints consGridBagConstraints4 =
				new java.awt.GridBagConstraints();
			java.awt.GridBagConstraints consGridBagConstraints11 =
				new java.awt.GridBagConstraints();
			java.awt.GridBagConstraints consGridBagConstraints12 =
				new java.awt.GridBagConstraints();
			java.awt.GridBagConstraints consGridBagConstraints22 =
				new java.awt.GridBagConstraints();
			java.awt.GridBagConstraints consGridBagConstraints21 =
				new java.awt.GridBagConstraints();
			consGridBagConstraints22.gridy = 7;
			consGridBagConstraints22.gridx = 0;
			consGridBagConstraints12.gridy = 6;
			consGridBagConstraints12.gridx = 0;
			consGridBagConstraints21.gridy = 5;
			consGridBagConstraints21.gridx = 0;
			consGridBagConstraints11.gridy = 4;
			consGridBagConstraints11.gridx = 0;
			consGridBagConstraints4.gridy = 3;
			consGridBagConstraints4.gridx = 0;
			consGridBagConstraints3.gridy = 2;
			consGridBagConstraints3.gridx = 0;
			consGridBagConstraints2.gridy = 1;
			consGridBagConstraints2.gridx = 0;
			consGridBagConstraints1.ipady = 0;
			consGridBagConstraints1.ipadx = 0;
			consGridBagConstraints1.gridy = 0;
			consGridBagConstraints1.gridx = 0;
			jContentPane.setLayout(new java.awt.GridBagLayout());
			jContentPane.add(getBtnGo(), consGridBagConstraints1);
			jContentPane.add(getBtnOptimisticUpdate(), consGridBagConstraints2);
			jContentPane.add(
				getBtnPessimisticUpdateWeakestLockAtLoad(),
				consGridBagConstraints3);
			jContentPane.add(
				getJButtonPessimisticUpdateExclusive(),
				consGridBagConstraints4);
			jContentPane.add(
				getJButtonStatefulSessionBean(),
				consGridBagConstraints11);
			jContentPane.add(
				getJButtonStatefulSessionBeanThreads(),
				consGridBagConstraints21);
			jContentPane.add(
				getBtnStatelessSessionBean(),
				consGridBagConstraints12);
			jContentPane.add(
				getBtnStatelessSessionBeanThreads(),
				consGridBagConstraints22);
		}
		return jContentPane;
	}
	/**
	 * This method initializes btnGo
	 * 
	 * @return javax.swing.JButton
	 */
	private javax.swing.JButton getBtnGo()
	{
		if (btnGo == null)
		{
			btnGo = new javax.swing.JButton();
			btnGo.setName("btnGo");
			btnGo.setText("Einzelner Aufruf !");
			btnGo.addActionListener(new java.awt.event.ActionListener()
			{
				public void actionPerformed(java.awt.event.ActionEvent e)
				{
					btnGo_actionPerformed();
				}
			});
		}
		return btnGo;
	}
	/**Auf Button "Go" wird geklickt: Action !
	 * 
	 *
	 */
	private void btnGo_actionPerformed()
	{
		System.out.println("actionPerformed()");
		try
		{
			//Jetzt loslegen (mit Default-AccessIntent).
			this.counter.incrementPessimisticUpdateWeakestLockAtLoad(
				"Einzelaufruf");
			//Wert erneut auslesen:
			JOptionPane.showMessageDialog(
				this,
				"Counter ist: " + this.counter.getCount());
		}
		catch (Exception ex)
		{
			ex.printStackTrace();
		}
	}
	/**
	 * This method initializes btnOptimisticUpdate
	 * 
	 * @return javax.swing.JButton
	 */
	private javax.swing.JButton getBtnOptimisticUpdate()
	{
		if (btnOptimisticUpdate == null)
		{
			btnOptimisticUpdate = new javax.swing.JButton();
			btnOptimisticUpdate.setName("btnOptimisticUpdate");
			btnOptimisticUpdate.setText("OptimisticUpdate");
			btnOptimisticUpdate.setToolTipText(
				"Wert wird am Ende nur um 1 erhht, da beide Threads durchlaufen");
			btnOptimisticUpdate
				.addActionListener(new java.awt.event.ActionListener()
			{
				public void actionPerformed(java.awt.event.ActionEvent e)
				{
					btnPessimisticRead_actionPerformed();
				}
			});
		}
		return btnOptimisticUpdate;
	}
	/**
		 * This method initializes btnPessimisticUpdateWeakestLockAtLoad
		 * 
		 * @return javax.swing.JButton
		 */
	private javax.swing.JButton getBtnPessimisticUpdateWeakestLockAtLoad()
	{
		if (btnPessimisticUpdateWeakestLockAtLoad == null)
		{
			btnPessimisticUpdateWeakestLockAtLoad = new javax.swing.JButton();
			btnPessimisticUpdateWeakestLockAtLoad.setName(
				"btnPessimisticUpdateWeakestLockAtLoad");
			btnPessimisticUpdateWeakestLockAtLoad.setText(
				"PessimisticUpdateWeakestLockAtLoad");
			btnPessimisticUpdateWeakestLockAtLoad.setToolTipText(
				"beide getCount laufen durch, beide sets mit identischen Werten ebenfalls");
			btnPessimisticUpdateWeakestLockAtLoad
				.addActionListener(new java.awt.event.ActionListener()
			{
				public void actionPerformed(java.awt.event.ActionEvent e)
				{
					btnPessimisticUpdateWeakestLockAtLoad_actionPerformed();
				}
			});
		}
		return btnPessimisticUpdateWeakestLockAtLoad;
	}
	/**Auf Button "PessimisticRead" wird geklickt: Thread-Action !
	 * 
	 */
	private void btnPessimisticRead_actionPerformed()
	{
		System.out.println("ConcurrentThreading wird gestartet");
		try
		{
			//2 Threads erzeugen und direkt loshampeln lassen.
			Thread threadOne =
				new Thread(
					new ConcurrentThreadOptimisticUpdate(
						this.counter,
						"Thread1"));
			threadOne.start();
			Thread.sleep(1000);
			Thread threadTwo =
				new Thread(
					new ConcurrentThreadOptimisticUpdate(
						this.counter,
						"Thread2"));
			threadTwo.start();
		}
		catch (Exception ex)
		{
			ex.printStackTrace();
		}
	}
	/**Auf Button "PessimisticUpdateWeakestLockAtLoad" wird geklickt: Thread-Action !
	 *  
	 */
	private void btnPessimisticUpdateWeakestLockAtLoad_actionPerformed()
	{
		System.out.println("PessimisticUpdateWeakestLockAtLoad wird gestartet");
		try
		{
			//2 Threads erzeugen und direkt loshampeln lassen.
			Thread threadOne =
				new Thread(
					new ConcurrentThreadPessimisticUpdateWeakestLockAtLoad(
						this.counter,
						"Thread1"));
			threadOne.start();
			Thread.sleep(1000);
			Thread threadTwo =
				new Thread(
					new ConcurrentThreadPessimisticUpdateWeakestLockAtLoad(
						this.counter,
						"Thread2"));
			threadTwo.start();
		}
		catch (Exception ex)
		{
			ex.printStackTrace();
		}
	}
	/**Auf Button "PessimisticUpdateExclusive" wird geklickt: Thread-Action !
	 *  
	 */
	private void btnPessimisticUpdateExclusive_actionPerformed()
	{
		System.out.println("PessimisticUpdateExclusive wird gestartet");
		try
		{
			//2 Threads erzeugen und direkt loshampeln lassen.
			Thread threadOne =
				new Thread(
					new ConcurrentThreadPessimisticUpdateExclusive(
						this.counter,
						"Thread1"));
			threadOne.start();
			Thread.sleep(1000);
			Thread threadTwo =
				new Thread(
					new ConcurrentThreadPessimisticUpdateExclusive(
						this.counter,
						"Thread2"));
			threadTwo.start();
		}
		catch (Exception ex)
		{
			ex.printStackTrace();
		}
	}
	/**
	 * This method initializes jButtonPessimisticUpdateExclusive
	 * 
	 * @return javax.swing.JButton
	 */
	private javax.swing.JButton getJButtonPessimisticUpdateExclusive()
	{
		if (jButtonPessimisticUpdateExclusive == null)
		{
			jButtonPessimisticUpdateExclusive = new javax.swing.JButton();
			jButtonPessimisticUpdateExclusive.setText(
				"PessimisticUpdateExclusive");
			jButtonPessimisticUpdateExclusive.setName(
				"btnPessimisticUpdateExclusive");
			jButtonPessimisticUpdateExclusive.setSelected(false);
			jButtonPessimisticUpdateExclusive.setToolTipText(
				"das erste getCount blockiert solange den Server, bis setCount ausgefhrt wurde. Dann kommt erst der zweite Thread.");
			jButtonPessimisticUpdateExclusive
				.addActionListener(new java.awt.event.ActionListener()
			{
				public void actionPerformed(java.awt.event.ActionEvent e)
				{
					btnPessimisticUpdateExclusive_actionPerformed();
				}
			});
		}
		return jButtonPessimisticUpdateExclusive;
	}
	/**
	 * This method initializes jButtonStatefulSessionBean
	 * 
	 * @return javax.swing.JButton
	 */
	private javax.swing.JButton getJButtonStatefulSessionBean()
	{
		if (jButtonStatefulSessionBean == null)
		{
			jButtonStatefulSessionBean = new javax.swing.JButton();
			jButtonStatefulSessionBean.setName("btnSessionBean");
			jButtonStatefulSessionBean.setText("ber Sessionbean direkt");
			jButtonStatefulSessionBean.setToolTipText(
				"Count ber Sessionbean aktualisieren");
			jButtonStatefulSessionBean
				.addActionListener(new java.awt.event.ActionListener()
			{
				public void actionPerformed(java.awt.event.ActionEvent e)
				{
					System.out.println("actionPerformed()");
					btnSessionBean_actionPerformed();
				}
			});
		}
		return jButtonStatefulSessionBean;
	}
	/**Klick auf den Button "ber SessionBean".
	 * 
	 *
	 */
	private void btnSessionBean_actionPerformed()
	{
		//SessionBean holen:
		try
		{
			//Home-Interface holen:
			ConcurrencyTesterStateful tester =
				this.concurrencyTesterStatefulHome.create();
			//Methode aufrufen:
			//tester.updateCount("Ohne Thread");
			tester.incrementPessimisticUpdateExclusive("Ohne Thread");
			JOptionPane.showMessageDialog(this, "Fertig !");
		}
		catch (Exception ex)
		{
			ex.printStackTrace();
		}
	}
	/**
	 * This method initializes jButtonStatefulSessionBeanThreads
	 * 
	 * @return javax.swing.JButton
	 */
	private javax.swing.JButton getJButtonStatefulSessionBeanThreads()
	{
		if (jButtonStatefulSessionBeanThreads == null)
		{
			jButtonStatefulSessionBeanThreads = new javax.swing.JButton();
			jButtonStatefulSessionBeanThreads.setName("btnSessionBeanThread");
			jButtonStatefulSessionBeanThreads.setText(
				"ber Session Bean (2 Threads)");
			jButtonStatefulSessionBeanThreads
				.addActionListener(new java.awt.event.ActionListener()
			{
				public void actionPerformed(java.awt.event.ActionEvent e)
				{
					System.out.println("actionPerformed()");
					btnSessionBeanThread_actionPerformed();
				}
			});
		}
		return jButtonStatefulSessionBeanThreads;
	}
	/**Klick auf den Button "ber SessionBean (Threads)".
		 * 
		 *
		 */
	private void btnSessionBeanThread_actionPerformed()
	{
		try
		{
			//Home-Interface holen:
			//2 Threads erzeugen und direkt loshampeln lassen.
			//Jeder Thread MUSS auf einer eigenen Instanz hampeln, da die Instanzen nicht
			//re-entrant sind !
			Thread threadOne =
				new Thread(
					new ConcurrencyThreadStatefulSession(
						this.concurrencyTesterStatefulHome.create(),
						"Thread1"));
			threadOne.start();
			Thread.sleep(1000);
			Thread threadTwo =
				new Thread(
					new ConcurrencyThreadStatefulSession(
						this.concurrencyTesterStatefulHome.create(),
						"Thread2"));
			threadTwo.start();
		}
		catch (Exception ex)
		{
			ex.printStackTrace();
		}
	}
	/**
	 * This method initializes btnStatelessSessionBean
	 * 
	 * @return javax.swing.JButton
	 */
	private javax.swing.JButton getBtnStatelessSessionBean()
	{
		if (btnStatelessSessionBean == null)
		{
			btnStatelessSessionBean = new javax.swing.JButton();
			btnStatelessSessionBean.setText(
				"ber Stateless SessionBean direkt");
			btnStatelessSessionBean
				.addActionListener(new java.awt.event.ActionListener()
			{
				public void actionPerformed(java.awt.event.ActionEvent e)
				{
					btnStatelessSessionBean_actionPerformed();
				}
			});
		}
		return btnStatelessSessionBean;
	}
	/**Klick auf den Button "ber Stateless SessionBean".
		 * 
		 *
		 */
	private void btnStatelessSessionBean_actionPerformed()
	{
		//SessionBean holen:
		try
		{
			//Home-Interface holen:
			ConcurrencyTesterStateless tester =
				this.concurrencyTesterStatelessHome.create();
			//Methode aufrufen:
			tester.incrementPessimisticUpdateExclusive("Ohne Thread");
			JOptionPane.showMessageDialog(this, "Fertig !");
		}
		catch (Exception ex)
		{
			ex.printStackTrace();
		}
	}
	/**
	 * This method initializes btnStatelessSessionBeanThreads
	 * 
	 * @return javax.swing.JButton
	 */
	private javax.swing.JButton getBtnStatelessSessionBeanThreads()
	{
		if (btnStatelessSessionBeanThreads == null)
		{
			btnStatelessSessionBeanThreads = new javax.swing.JButton();
			btnStatelessSessionBeanThreads.setText(
				"ber Stateless SessionBean (2 Threads)");
			btnStatelessSessionBeanThreads
				.addActionListener(new java.awt.event.ActionListener()
			{
				public void actionPerformed(java.awt.event.ActionEvent e)
				{
					btnStatelessSessionBeanThread_actionPerformed();
				}
			});
		}
		return btnStatelessSessionBeanThreads;
	}
	/**Klick auf den Button "ber Stateless SessionBean (Threads)".
	 * 
	 *
	 */
	private void btnStatelessSessionBeanThread_actionPerformed()
	{
		try
		{
			//Home-Interface holen:
			//2 Threads erzeugen und direkt loshampeln lassen.
			//Jeder Thread MUSS auf einer eigenen Instanz hampeln, da die Instanzen nicht
			//re-entrant sind !
			Thread threadOne =
				new Thread(
					new ConcurrencyThreadStatelessSession(
						this.concurrencyTesterStatelessHome.create(),
						"Thread1"));
			threadOne.start();
			Thread.sleep(1000);
			Thread threadTwo =
				new Thread(
					new ConcurrencyThreadStatelessSession(
						this.concurrencyTesterStatelessHome.create(),
						"Thread2"));
			threadTwo.start();
		}
		catch (Exception ex)
		{
			ex.printStackTrace();
		}
	}
} //  @jve:visual-info  decl-index=0 visual-constraint="10,10"
