package com.knauf.ejb.concurrency;
import java.rmi.RemoteException;
import javax.ejb.CreateException;
import javax.ejb.EJBException;
import javax.ejb.FinderException;
import javax.naming.InitialContext;
import javax.rmi.PortableRemoteObject;
/**
 * Stateful Session Bean fr den Test der CounterBean.
 * Der State ist die Referenz auf die Bean.
 */
public class ConcurrencyTesterStatefulBean implements javax.ejb.SessionBean
{
	/**Die CounterBean, die von dieser Bean manipuliert werden soll. */
	private Counter counter = null;
	private javax.ejb.SessionContext mySessionCtx;
	/**
	 * getSessionContext
	 */
	public javax.ejb.SessionContext getSessionContext()
	{
		return mySessionCtx;
	}
	/**
	 * setSessionContext
	 */
	public void setSessionContext(javax.ejb.SessionContext ctx)
	{
		mySessionCtx = ctx;
	}
	/**Initialisieren der Stateful Session Bean: Erzeugen der Counter-Bean Instanz.
	 */
	public void ejbCreate() throws javax.ejb.CreateException
	{
		try
		{
			//Home-Interface holen:
			InitialContext initialContext = new InitialContext();
			Object homeref = initialContext.lookup("java:comp/env/ejb/Counter");
			CounterHome counterHome =
				(CounterHome) PortableRemoteObject.narrow(
					homeref,
					CounterHome.class);
			//Gibt es die Bean mit der ID 100 schon ?
			try
			{
				this.counter = counterHome.findByPrimaryKey(new Integer(100));
			}
			catch (FinderException fex)
			{
				//Bean existiert nicht: erzeugen.
				this.counter = counterHome.create(new Integer(100));
				//Und Startwert aus "1" setzen:
				this.counter.setCount(new Integer(1));
			}
		}
		catch (Exception ex)
		{
			throw new CreateException(
				"Fehler beim Initialisieren der Stateful Session Bean: "
					+ ex.getMessage());
		}
	}
	/**
	 * ejbActivate
	 */
	public void ejbActivate()
	{
	}
	/**
	 * ejbPassivate
	 */
	public void ejbPassivate()
	{
	}
	/**
	 * ejbRemove
	 */
	public void ejbRemove()
	{
	}
	/**Die einzige Geschftsmethode: Ausfhren von Arbeit in der Bean.
	 * 
	 * @param _strKennung Eine Kennung fr Threadausgaben.
	 */
	public void incrementPessimisticUpdateExclusive(String _strKennung)
	{
		try
		{
			//this.counter.incrementPessimisticUpdateExclusive(_strKennung);
			this.counter.incrementPessimisticUpdateWeakestLockAtLoad(_strKennung);
		}
		catch (RemoteException rex)
		{
			throw new EJBException(
				"RemoteException in incrementPessimisticUpdateExclusive !",
				rex);
		}
	}
}
