package com.knauf.ejb.concurrency;

import javax.ejb.FinderException;
import javax.naming.InitialContext;
import javax.rmi.PortableRemoteObject;
/**
 * Stateless Session Bean fr den Concurrent Zugriff auf die CounterBean.
 * 
 */
public class ConcurrencyTesterStatelessBean implements javax.ejb.SessionBean
{
	private javax.ejb.SessionContext mySessionCtx;
	/**
	 * getSessionContext
	 */
	public javax.ejb.SessionContext getSessionContext()
	{
		return mySessionCtx;
	}
	/**
	 * setSessionContext
	 */
	public void setSessionContext(javax.ejb.SessionContext ctx)
	{
		mySessionCtx = ctx;
	}
	/**
	 * ejbCreate
	 */
	public void ejbCreate() throws javax.ejb.CreateException
	{
	}
	/**
	 * ejbActivate
	 */
	public void ejbActivate()
	{
	}
	/**
	 * ejbPassivate
	 */
	public void ejbPassivate()
	{
	}
	/**
	 * ejbRemove
	 */
	public void ejbRemove()
	{
	}
	/**Den Counter in der einzigen Entity Bean hochzhlen.
	 * @param _strKennung Beliebige Kennung um Logausgaben zu erkennen.
	 *
	 */
	public void incrementPessimisticUpdateExclusive(String _strKennung)
	{
		try
		{
			//Home-Interface holen:
			InitialContext initialContext = new InitialContext();
			Object homeref = initialContext.lookup("java:comp/env/ejb/Counter");
			CounterHome counterHome =
				(CounterHome) PortableRemoteObject.narrow(
					homeref,
					CounterHome.class);
			//Gibt es die Bean mit der ID 100 schon ?
			Counter counter = null;
			try
			{
				counter = counterHome.findByPrimaryKey(new Integer(100));
			}
			catch (FinderException fex)
			{
				//Bean existiert nicht: erzeugen.
				counter = counterHome.create(new Integer(100));
				//Und Startwert aus "1" setzen:
				counter.setCount(new Integer(1));
			}
			//Jetzt mit dem hchsten AccessIntent-Level arbeiten (wird wegen Finder-Methode
			//ignoriert):
			System.err.println ("ConcurrencyTesterStatelessBean.incrementPessimisticUpdateExclusive (" + _strKennung + ")");
			counter.incrementPessimisticUpdateExclusive(_strKennung);
		}
		catch (Exception ex)
		{
			ex.printStackTrace();
		}
	}
}
