package com.knauf.ejb.concurrency;
/**
 * Bean implementation class for Enterprise Bean: Counter
 */
public abstract class CounterBean implements javax.ejb.EntityBean
{
	private javax.ejb.EntityContext myEntityCtx;
	/**
	 * setEntityContext
	 */
	public void setEntityContext(javax.ejb.EntityContext ctx)
	{
		myEntityCtx = ctx;
	}
	/**
	 * getEntityContext
	 */
	public javax.ejb.EntityContext getEntityContext()
	{
		return myEntityCtx;
	}
	/**
	 * unsetEntityContext
	 */
	public void unsetEntityContext()
	{
		myEntityCtx = null;
	}
	/**
	 * ejbCreate
	 */
	public java.lang.Integer ejbCreate(java.lang.Integer id)
		throws javax.ejb.CreateException
	{
		setId(id);
		return null;
	}
	/**
	 * ejbPostCreate
	 */
	public void ejbPostCreate(java.lang.Integer id)
		throws javax.ejb.CreateException
	{
	}
	/**
	 * ejbActivate
	 */
	public void ejbActivate()
	{
	}
	/**
	 * ejbLoad
	 */
	public void ejbLoad()
	{
	}
	/**
	 * ejbPassivate
	 */
	public void ejbPassivate()
	{
	}
	/**
	 * ejbRemove
	 */
	public void ejbRemove() throws javax.ejb.RemoveException
	{
	}
	/**
	 * ejbStore
	 */
	public void ejbStore()
	{
	}
	/**
	 * Get accessor for persistent attribute: id
	 */
	public abstract java.lang.Integer getId();
	/**
	 * Set accessor for persistent attribute: id
	 */
	public abstract void setId(java.lang.Integer newId);
	/**
	 * Get accessor for persistent attribute: count
	 */
	public abstract java.lang.Integer getCount();
	/**
	 * Set accessor for persistent attribute: count
	 */
	public abstract void setCount(java.lang.Integer newCount);
	/**Geschftsmethode. Fhrt ein Increment durch.
	 * AccessIntent sollte auf "wsOptimisticUpdate" gesetzt werden.
	 * Dazu den Wert von "count" lesen. Dann einige Zeit warten und abschlieend hochsetzen. 
	 * @param _strKennung Eine Kennung, die von auen mitgegeben wird. Dadurch knnen wir
	 * die Methoden unterscheiden. 
	 */
	public void incrementOptimisticUpdate(String _strKennung)
	{
		Integer intCount = this.getCount();
		System.err.println(
			"incrementOptimisticUpdate: Count gelesen (" + _strKennung + "): " + intCount);
		//Schlafen...
		try
		{
			Thread.sleep(5000);
		}
		catch (InterruptedException iex)
		{
			System.err.println("incrementOptimisticUpdate (" + _strKennung + "): Aufgeweckt :-(");
		}
		intCount = new Integer(intCount.intValue() + 1);
		System.err.println(
			"incrementOptimisticUpdate (" + _strKennung + "): Ausgeschlafen. Ich setze den Wert jetzt auf "
				+ intCount);
		//Hochsetzen:
		this.setCount(intCount);
	}
	/**Geschftsmethode. Fhrt ein Increment durch.
	 * AccessIntent sollte auf "wsPessimisticUpdate-WeakestLockAtLoad" gesetzt werden.
	 * Dazu den Wert von "count" lesen. Dann einige Zeit warten und abschlieend hochsetzen. 
	 * @param _strKennung Eine Kennung, die von auen mitgegeben wird. Dadurch knnen wir
	 * die Methoden unterscheiden. 
	 */
	public void incrementPessimisticUpdateWeakestLockAtLoad(String _strKennung)
	{
		Integer intCount = this.getCount();
		System.err.println(
			"incrementPessimisticUpdateWeakestLockAtLoad (" + _strKennung + "): Count gelesen: "
				+ intCount);
		//Schlafen...
		try
		{
			Thread.sleep(5000);
		}
		catch (InterruptedException iex)
		{
			System.err.println(
				"incrementPessimisticUpdateWeakestLockAtLoad (" + _strKennung + "): Aufgeweckt :-(");
		}
		intCount = new Integer(intCount.intValue() + 1);
		System.err.println(
			"incrementPessimisticUpdateWeakestLockAtLoad (" + _strKennung + "): Ausgeschlafen. Ich setze den Wert jetzt auf "
				+ intCount);
		//Hochsetzen:
		this.setCount(intCount);
	}
	/**Geschftsmethode. Fhrt ein Increment durch.
	 * AccessIntent sollte auf "wsPessimisticUpdateExclusive" gesetzt werden.
	 * Dazu den Wert von "count" lesen. Dann einige Zeit warten und abschlieend hochsetzen. 
	 * @param _strKennung Eine Kennung, die von auen mitgegeben wird. Dadurch knnen wir
	 * die Methoden unterscheiden. 
	 */
	public void incrementPessimisticUpdateExclusive(String _strKennung)
	{
		Integer intCount = this.getCount();
		System.err.println(
			"incrementPessimisticUpdateExclusive (" + _strKennung + "): Count gelesen: " + intCount);
		//Schlafen...
		try
		{
			Thread.sleep(5000);
		}
		catch (InterruptedException iex)
		{
			System.err.println(
				"incrementPessimisticUpdateExclusive (" + _strKennung + "): Aufgeweckt :-(");
		}
		intCount = new Integer(intCount.intValue() + 1);
		System.err.println(
			"incrementPessimisticUpdateExclusive (" + _strKennung + "): Ausgeschlafen. Ich setze den Wert jetzt auf "
				+ intCount);
		//Hochsetzen:
		this.setCount(intCount);
	}
}
