package de.fhw.swtvertiefung.knauf.security.loginmodule;

import java.sql.ResultSet;
import java.sql.SQLException;

/**
 * Ein einzelner Kunde. Dient nur dazu, seine Properties zu verwalten.
 * Sozusagen ein Value Object ohne Bean.
 */
public class Kunde
{
	/**Id  des Kunden. */
	private Integer intId = null;
	/**Anzeigename */
	private String strName = null;
	/**Der Login */
	private String strLogin = null;
	/**Das Passwort*/
	private String strPasswort = null;
	/**
	 * @return
	 */
	public Integer getId()
	{
		return intId;
	}
	/**
	 * @return
	 */
	public String getLogin()
	{
		return strLogin;
	}
	/**
	 * @return
	 */
	public String getName()
	{
		return strName;
	}
	/**
	 * @return
	 */
	public String getPasswort()
	{
		return strPasswort;
	}
	/**
	 * @param integer
	 */
	public void setId(Integer integer)
	{
		intId = integer;
	}
	/**
	 * @param string
	 */
	public void setLogin(String string)
	{
		strLogin = string;
	}
	/**
	 * @param string
	 */
	public void setName(String string)
	{
		strName = string;
	}
	/**
	 * @param string
	 */
	public void setPasswort(String string)
	{
		strPasswort = string;
	}
	
	/**Befllen des Kunden aus bergebenem ResultSet
	 * 
	 * @param rs
	 * @exception SQLException Fehler beim Abrufen der Daten.
	 */
	public void fromResultSet (ResultSet rs) throws SQLException
	{
		this.intId = (Integer) rs.getObject("ID");
		this.strName = (String) rs.getObject("NAME");
		this.strLogin = (String) rs.getObject("LOGIN");
		this.strPasswort = (String) rs.getObject("PASSWORT");
	}
}
