package com.knauf.ejb.kuchenzutatautopk;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.logging.Logger;
import javax.ejb.CreateException;
import javax.ejb.EntityContext;
import javax.ejb.EntityBean;

/**
 * Abstrakte Bean-Klasse fr ein Objekt "Kuchen".
 * Sie hat genau ein weiteres Feld: "Kuchen-Name".
 * Die ID wird vom Container erzeugt.
 *
 * Hier kommt noch die Zutatenliste hinzu.
 *
 * @author  Wolfgang Knauf
 */

public abstract class KuchenAutoPKBean implements EntityBean
{
  /**Entity-context der Bean */
  private EntityContext entityContext = null;

  /**Der Logger fr diverse Logausgaben */
  private static final Logger logger = Logger.getLogger(KuchenAutoPKBean.class.getName());

  /**Konstruktor.
   * 
   */
  public KuchenAutoPKBean()
  {
  }

  ////////////////////////////////////////////////////////////////////
  //          Methoden aus Interface EntityBean                    //
  ////////////////////////////////////////////////////////////////////

  /**Bean wird aktiviert.
   * @throws javax.ejb.EJBException
   * @throws java.rmi.RemoteException
   */
  public void ejbActivate() throws javax.ejb.EJBException, java.rmi.RemoteException
  {
    KuchenAutoPKBean.logger.info("ejbActivate");
  }

  /**Bean wird geladen.
   * @throws javax.ejb.EJBException
   * @throws java.rmi.RemoteException
   */
  public void ejbLoad() throws javax.ejb.EJBException, java.rmi.RemoteException
  {
    KuchenAutoPKBean.logger.info("ejbLoad");
  }

  /**Bean wird passiviert.
   * @throws javax.ejb.EJBException
   * @throws java.rmi.RemoteException
   */
  public void ejbPassivate() throws javax.ejb.EJBException, java.rmi.RemoteException
  {
    KuchenAutoPKBean.logger.info("ejbPassivate");
  }

  /**Bean wird gelscht.
   * @throws javax.ejb.EJBException
   * @throws java.rmi.RemoteException
   */
  public void ejbRemove() throws javax.ejb.RemoveException, javax.ejb.EJBException, java.rmi.RemoteException
  {
    KuchenAutoPKBean.logger.info("ejbRemove");
  }

  /**Bean wird gespeichert.
   * @throws javax.ejb.EJBException
   * @throws java.rmi.RemoteException
   */
  public void ejbStore() throws javax.ejb.EJBException, java.rmi.RemoteException
  {
    KuchenAutoPKBean.logger.info("ejbStore");
  }

  /**Entity-Context wird zurckgesetzt.
   * @throws javax.ejb.EJBException
   * @throws java.rmi.RemoteException
   */
  public void unsetEntityContext() throws javax.ejb.EJBException, java.rmi.RemoteException
  {
    this.entityContext = null;
  }

  /**Entity-Context wird gesetzt.
   * @throws javax.ejb.EJBException
   * @throws java.rmi.RemoteException
   */
  public void setEntityContext(EntityContext parm1) throws javax.ejb.EJBException, java.rmi.RemoteException
  {
    this.entityContext = parm1;
  }

  //////////////////////////////////////////////////////////////////////////////////
  //                   Zugriffsmethoden fr die Felder                            //
  //////////////////////////////////////////////////////////////////////////////////

  /**Abrufen des Kuchen-Namens.
   * @return der Kuchen-Name.
   */
  public abstract String getName();

  /**Setzen des Kuchen-Namens.
   * @param str_Name der Name
   */
  public abstract void setName(String str_Name);

  /**Abrufen aller Zutaten dieses Kuchens.
   * @return Collection von Zutat-Objekten.
   */
  public abstract Collection getZutaten();

  /**Setzen der kompletten Zutaten-Liste des Kuchens.
   * Wird vom Container bernommen.
   * @param coll_Zutaten Liste der Zutaten.
   */
  public abstract void setZutaten(Collection coll_Zutaten);

  /**Hinzufgen einer Zutat zu den Zutaten dieses Kuchens (die einzige Business-Methode).
   * @param zutat Die zuzufgende Zutat.
   */
  public void addZutat(LocalZutatAutoPK zutat)
  {
    Collection collZutaten = this.getZutaten();
    collZutaten.add(zutat);
    KuchenAutoPKBean.logger.info("Anzahl Zutaten: " + collZutaten.size());
  }

  /**Abrufen der Zutatenliste.
   * NUR hierber darf ein Client an die Zutaten kommen. "getZutaten" ist nur fr den Container ?
   * @return Eine Liste aller Zutaten.
   */
  public ArrayList getZutatenListe()
  {
    ArrayList list = new ArrayList();
    Iterator c = this.getZutaten().iterator();
    while (c.hasNext())
    {
      list.add((LocalZutatAutoPK) c.next());
    }
    return list;
  }

  //////////////////////////////////////////////////////////////////////////////////
  //                          Weitere Methoden                                    //
  //////////////////////////////////////////////////////////////////////////////////

  /**Erzeugen eines Kuchen-Objekts, wobei der Name angegeben wird. Der Key wird vom Container
   * erzeugt.
   * @param str_Name Der Name des Kuchens.
   * @return NULL, da der Container die ID erzeugen muss.
   * @exception CreateException Fehler beim Erzeugen.
   */
  public Object ejbCreateByName(String str_Name) throws CreateException
  {
    KuchenAutoPKBean.logger.info("ejbCreateByName: " + str_Name);
    this.setName(str_Name);

    return null;
  }

  /**Erzeugen eines Kuchen-Objekts, Name ist noch nicht gegeben. Der Key wird vom Container
   * erzeugt.
   * @return NULL, da der Container die ID erzeugen muss.
   * @exception CreateException Fehler beim Erzeugen.
   */
  public Object ejbCreate() throws CreateException
  {
    KuchenAutoPKBean.logger.info("ejbCreate");

    return null;
  }

  /**Nach dem Erzeugen eines Kuchen-Objekts, wobei der Name angegeben wird: nichts besonderes zu tun.
   * @param str_Name Der Name des Kuchens.
   * @exception CreateException Fehler beim Erzeugen.
   */
  public void ejbPostCreateByName(String str_Name) throws CreateException
  {
    KuchenAutoPKBean.logger.info("ejbPostCreateByName: " + str_Name);
  }

  /**Nach dem Erzeugen eines Kuchen-Objekts, Name ist noch nicht gegeben.
   * @exception CreateException Fehler beim Erzeugen.
   */
  public void ejbPostCreate() throws CreateException
  {
    KuchenAutoPKBean.logger.info("ejbPostCreate");
  }
}