package com.knauf.ejb.kuchenzutatautopk;

import java.rmi.RemoteException;
import java.util.ArrayList;
import javax.ejb.EJBLocalObject;

/**
 * Local-Interface der Kuchen-Bean.
 * Enthlt nur die Methoden zum Setzen der Properties.
 * Darf kein Remote-Home-Interface sein, da in beide Richtungen (von Kuchen zu Zutat und
 * von Zutat zu Kuchen) referenziert werden kann.
 * 
 * @author  Wolfgang Knauf
 */

public interface LocalKuchenAutoPK extends EJBLocalObject
{
  /**Abrufen des Kuchen-Namens.
   * @exception RemoteException Bei Netzwerkfehlern.
   */
  public String getName() throws RemoteException;

  /**Setzen des Kuchen-Namens.
   * @param str_Name Neuer Name.
   * @exception RemoteException Bei Netzwerkfehlern.
   */
  public void setName (String str_Name) throws RemoteException;

  /**Abrufen aller Zutaten dieses Kuchens.
   * WARNUNG: Die Zutatenliste darf nicht direkt als Collection zurckgeliefert werden,
   * die von der Bean-Methode "getZutaten" kommt, sondern MUSS in eine ArrayList umgewandelt werden.
   * @return Collection von Zutat-Objekten.
   * @exception RemoteException Bei Netzwerkfehlern.
   */
  public ArrayList getZutatenListe() throws RemoteException;

  /**Hinzufgen einer Zutat zu den Zutaten dieses Kuchens (die einzige Business-Methode).
   * @param zutat Die zuzufgende Zutat.
   * @exception RemoteException Bei Netzwerkfehlern.
   */
  public void addZutat (LocalZutatAutoPK zutat) throws RemoteException;
}