package com.knauf.ejb.kuchenzutatautopk;

import java.rmi.RemoteException;
import java.util.Collection;
import javax.ejb.CreateException;
import javax.ejb.EJBLocalHome;
import javax.ejb.FinderException;

/**
 * Local-Home-Interface des leckeren Kuchens.
 * Deklariert die diversen Create-Methoden.
 * Darf kein Remote-Home-Interface sein, da in beide Richtungen (von Kuchen zu Zutat und
 * von Zutat zu Kuchen) referenziert werden kann.
 * 
 * @author  Wolfgang Knauf
 */

public interface LocalKuchenAutoPKHome extends EJBLocalHome
{
  /**Erzeugen eines Kuchen-Objekts, wobei der Name angegeben wird. Der Key wird automatisch erzeugt.
   * @param str_Name Der Name des Kuchens.
   * @return Der erzeugte Kuchen.
   * @exception CreateException Fehler beim Erzeugen.
   * @exception RemoteException Bei Netzwerkfehlern.
   */
  public LocalKuchenAutoPK createByName (String str_Name) throws CreateException, RemoteException;

  /**Erzeugen eines Kuchen-Objekts, Name ist noch nicht gegeben. Der Key wird automatisch erzeugt.
   * @return Der erzeugte Kuchen.
   * @exception CreateException Fehler beim Erzeugen.
   * @exception RemoteException Bei Netzwerkfehlern.
   */
  public LocalKuchenAutoPK create () throws CreateException, RemoteException;

  /**Laden eines Kuchen-Objekts anhand des Primary Keys. Der Key wird vom Container verwaltet.
   * @param obj_PrimaryKey Der Key des Kuchens.
   * @return Den anhand des Keys gefundenen Kuchen.
   * @exception FinderException Fehler beim Finden.
   * @exception RemoteException Bei Netzwerkfehlern.
   */
  public LocalKuchenAutoPK findByPrimaryKey(Object obj_PrimaryKey) throws FinderException, RemoteException;


  /**Laden aller Kuchen-Objekte.
   * @return Eine Collection aller Kuchen.
   * @exception FinderException Fehler beim Finden.
   * @exception RemoteException Bei Netzwerkfehlern.
   */
  public Collection findAll() throws FinderException, RemoteException;
}