package com.knauf.ejb.kuchenzutatautopk;

import java.rmi.RemoteException;
import javax.ejb.EJBLocalObject;

/**
 * Title:
 * Description:  Local-Interface der Kuchen-Zutat.
 *               Darf kein Remote-Interface sein, da in beide Richtungen (von Kuchen zu Zutat und
 *               von Zutat zu Kuchen) referenziert werden kann.
 * Copyright:    Copyright (c) 2004
 * Company:
 * @author
 * @version 1.0
 */

public interface LocalZutatAutoPK extends EJBLocalObject
{
  /**Abrufen des Zutat-Namens.
   * @exception RemoteException Bei Netzwerkfehlern.
   */
  public String getZutatName() throws RemoteException;

  /**Setzen des Zutat-Namens.
   * @param str_Name Neuer Name.
   * @exception RemoteException Bei Netzwerkfehlern.
   */
  public void setZutatName (String str_Name) throws RemoteException;

  /**Abrufen der Menge (als String)
   * @exception RemoteException Bei Netzwerkfehlern.
   */
  public String getMenge() throws RemoteException;

  /**Setzen der menge als String
   * @param str_Menge Neue Menge
   * @exception RemoteException Bei Netzwerkfehlern.
   */
  public void setMenge (String str_Menge) throws RemoteException;

  /**Abrufen des Kuchens, zu dem die Zutat gehrt.
   * @return Der Kuchen der Zutat.
   */
  public LocalKuchenAutoPK getKuchen() throws RemoteException;

  /**Setzen des Kuchens, zu dem die Zutat gehrt.
   * Diese SET-Methode gehrt scheinbar nicht ins Remote-Interface ?!
   * @param kuchen Der Kuchen der Zutat.
   */
  //public void setKuchen(LocalKuchen kuchen) throws RemoteException;
}