package com.knauf.ejb.kuchenzutatautopk;

import java.rmi.RemoteException;
import javax.ejb.CreateException;
import javax.ejb.FinderException;
import javax.ejb.EJBLocalHome;

/**
 * Title:
 * Description:  Local-Home-Interface fr eine Zutat.


 * Copyright:    Copyright (c) 2004
 * Company:
 * @author
 * @version 1.0
 */

public interface LocalZutatAutoPKHome extends EJBLocalHome
{
  /**Erzeugen eines Zutat-Objekts, wobei Name und Menge angegeben wird. Der Key wird automatisch in
   * der Bean erzeugt.
   * @param str_Name Der Name der Zutat.
   * @param str_Menge Die Menge der Zutat
   * @return Die erzeugte Zutat
   * @exception CreateException Fehler beim Erzeugen.
   * @exception RemoteException Bei Netzwerkfehlern.
   */
  public LocalZutatAutoPK createByNameMenge (String str_Name, String str_Menge) throws CreateException, RemoteException;

  /**Erzeugen eines Zutat-Objekts, Name und Menge sind noch nicht gegeben. Der Key wird automatisch in
   * der Bean erzeugt.
   * @return Die erzeugte Zutat
   * @exception CreateException Fehler beim Erzeugen.
   * @exception RemoteException Bei Netzwerkfehlern.
   */
  public LocalZutatAutoPK create () throws CreateException, RemoteException;

  /**Laden einer Zutat anhand des Primary Keys.
   * @param obj_PrimaryKey Der Primrschlssel der Zutat, vom Container vergeben.
   * @return Die anhand des Keys gefundenen Zutat.
   * @exception FinderException Fehler beim Finden.
   * @exception RemoteException Bei Netzwerkfehlern.
   */
  public LocalZutatAutoPK findByPrimaryKey(Object obj_PrimaryKey) throws FinderException, RemoteException;
}