package com.knauf.ejb.kuchenzutatautopk;

import java.util.logging.Logger;
import javax.ejb.CreateException;
import javax.ejb.EntityContext;
import javax.ejb.EntityBean;

/**
 * Diese Bean bildet eine Zutat fr den Kuchen ab.
 * Werte sind:
 * a) Autogenerierter Primary Key.
 * b) Name der Zutat
 * c) Menge
 * 
 * @author Wolfgang Knauf
 */

public abstract class ZutatAutoPKBean implements EntityBean
{
  /**Der Entity-Context der Bean */
  private EntityContext entityContext = null;

  /**Der Logger. */
  private static final Logger logger = Logger.getLogger(ZutatAutoPKBean.class.getName());

  /**Konstruktor
   * 
   */
  public ZutatAutoPKBean()
  {
  }

////////////////////////////////////////////////////////////////////
  //          Methoden aus Interface EntityBean                    //
  ////////////////////////////////////////////////////////////////////

  /**Bean wird aktiviert.
   * @throws javax.ejb.EJBException
   * @throws java.rmi.RemoteException
   */
  public void ejbActivate() throws javax.ejb.EJBException, java.rmi.RemoteException
  {
    ZutatAutoPKBean.logger.info("ejbActivate");
  }

  /**Bean wird geladen.
   * @throws javax.ejb.EJBException
   * @throws java.rmi.RemoteException
   */
  public void ejbLoad() throws javax.ejb.EJBException, java.rmi.RemoteException
  {
    ZutatAutoPKBean.logger.info("ejbLoad");
  }

  /**Bean wird passiviert.
   * @throws javax.ejb.EJBException
   * @throws java.rmi.RemoteException
   */
  public void ejbPassivate() throws javax.ejb.EJBException, java.rmi.RemoteException
  {
    ZutatAutoPKBean.logger.info("ejbPassivate");
  }

  /**Bean wird gelscht.
   * @throws javax.ejb.EJBException
   * @throws java.rmi.RemoteException
   */
  public void ejbRemove() throws javax.ejb.RemoveException, javax.ejb.EJBException, java.rmi.RemoteException
  {
    ZutatAutoPKBean.logger.info("ejbRemove");
  }

  /**Bean wird gespeichert.
   * @throws javax.ejb.EJBException
   * @throws java.rmi.RemoteException
   */
  public void ejbStore() throws javax.ejb.EJBException, java.rmi.RemoteException
  {
    ZutatAutoPKBean.logger.info("ejbStore");
  }

  /**Entity-Context wird zurckgesetzt.
   * @throws javax.ejb.EJBException
   * @throws java.rmi.RemoteException
   */
  public void unsetEntityContext() throws javax.ejb.EJBException, java.rmi.RemoteException
  {
    ZutatAutoPKBean.logger.info("unsetEntityContext");
    this.entityContext = null;
  }

  /**Entity-Context wird gesetzt.
   * @throws javax.ejb.EJBException
   * @throws java.rmi.RemoteException
   */
  public void setEntityContext(EntityContext parm1) throws javax.ejb.EJBException, java.rmi.RemoteException
  {
    ZutatAutoPKBean.logger.info("setEntityContext");
    this.entityContext = parm1;
  }


  //////////////////////////////////////////////////////////////////////////////////
  //                   Zugriffsmethoden fr die Felder                            //
  //////////////////////////////////////////////////////////////////////////////////
  /**Abrufen des Zutat-Namens.
   * @return Der Zutat-Name
   */
  public abstract String getZutatName();

  /**Setzen des Zutat-Namens.
   * @param str_Name Der neue Name.
   */
  public abstract void setZutatName(String str_Name);

  /**Abrufen der Menge. 
   * @return Die Menge der Zutat ("100 Gramm", "2 Stck")
   */
  public abstract String getMenge();

  /**Setzen der Menge ("100 Gramm", "2 Stck")
   * @param str_Menge Neue Menge.
   */
  public abstract void setMenge(String str_Menge);

  /**Abrufen des Kuchens, zu dem die Zutat gehrt.
   * @return Der Kuchen der Zutat.
   */
  public abstract LocalKuchenAutoPK getKuchen();

  /**Setzen des Kuchens, zu dem die Zutat gehrt.
   * @param kuchen Der Kuchen der Zutat.
   */
  public abstract void setKuchen(LocalKuchenAutoPK kuchen);

  //////////////////////////////////////////////////////////////////////////////////
  //                          Weitere Methoden                                    //
  //////////////////////////////////////////////////////////////////////////////////

  /**Erzeugen eines Zutat-Objekts, wobei Name und Menge angegeben wird. Der Key wird vom Container
   * erzeugt.
   * @param str_Name Der Name der Zutat
   * @param str_Menge Die Menge der Zutat
   * @return Immer NULL.
   * @exception CreateException Fehler beim Erzeugen.
   */
  public Object ejbCreateByNameMenge (String str_Name, String str_Menge) throws CreateException
  {
    ZutatAutoPKBean.logger.info("ejbCreateByNameMenge: " + str_Name + ", " + str_Menge);
    this.setZutatName(str_Name);
    this.setMenge(str_Menge);

    return null;
  }

  /**Erzeugen eines Zutat-Objekts, Name und Menge sind noch nicht gegeben. Der Primary Key wird vom Container
   * erzeugt.
   * @return Immer NULL
   * @exception CreateException Fehler beim Erzeugen.
   */
  public Object ejbCreate () throws CreateException
  {
    ZutatAutoPKBean.logger.info("ejbCreate");

    return null;
  }

  /**Nach dem Erzeugen eines Zutat-Objekts, wobei Name und Menge angegeben werden: nichts besonderes zu tun.
   * @param str_Name Der Name der Zutat.
   * @param str_Menge Menge der Zutat
   * @exception CreateException Fehler beim Erzeugen.
   */
  public void ejbPostCreateByNameMenge (String str_Name, String str_Menge) throws CreateException
  {
    ZutatAutoPKBean.logger.info("ejbPostCreateByNameMenge: " + str_Name + ", " + str_Menge);
  }

  /**Nach dem Erzeugen eines Zutat-Objekts, Name und Menge sind noch nicht gegeben.
   * @exception CreateException Fehler beim Erzeugen.
   */
  public void ejbPostCreate () throws CreateException
  {
    ZutatAutoPKBean.logger.info("ejbPostCreate");
  }
}