type Parser result token = [token] -> [(result,[token])]

getToken tok [] = []
getToken tok (x:xs)
  |tok==x = [(x,xs)]
  |otherwise = []

alt p1 p2 toks 
  |null res1 = p2 toks
  |otherwise = res1
 where
  res1 = p1 toks

seqP p1 p2 toks = concat
  [[((rs1,rs2),tks2) |(rs2,tks2)<-(p2 tks1) ] 
  |(rs1,tks1)<-p1 toks]

mapP f p toks = [(f rs,tks)|(rs,tks)<-p toks]

parantheses = mapP (\((x1,x2),x3) -> x2)
     (getToken '(' `seqP` a `seqP` getToken ')')

a = getToken 'a' `alt` parantheses

main = do 
  print (parantheses "((((a))))")
  print (parantheses "((((a)))")
  print (parantheses "((((a))))bc")

