package company;
import name.panitz.crempel.util.xml.parslib.*;
import name.panitz.crempel.util.*;
import java.util.*;
import org.w3c.dom.Node;

public class CompanyParser extends AbstractParser<Company>{
public ParseResult<Company> parse(List<Node> xs){  return getVCompany().parse(xs);}



  private Parser<Address> vAddress = null;
  public Parser<Address> getVAddress(){
    if (vAddress==null){
      vAddress = new Element<Address>("Address"
     ,new Closure<Parser<Address>>(){public Parser<Address> eval(){return new PCData()
     .<Address>map(new Function1<String,Address>(){
       public Address eval(String x){
         return new Address(x);
       }
     })
;}}//end of closure
);
    }
    return vAddress;
  }

  private Parser<Choice_PU_DU> vChoice_PU_DU = null;
  public Parser<Choice_PU_DU> getVChoice_PU_DU(){
    if (vChoice_PU_DU==null){
      vChoice_PU_DU = getVPU().<Choice_PU_DU>map(new Function1<PU,Choice_PU_DU>(){
    public Choice_PU_DU eval(PU x){
      return (Choice_PU_DU)new CChoice_PU_DUPU(x);
    }
  }).choice(getVDU().<Choice_PU_DU>map(new Function1<DU,Choice_PU_DU>(){
    public Choice_PU_DU eval(DU x){
      return (Choice_PU_DU)new CChoice_PU_DUDU(x);
    }
  }));
    }
    return vChoice_PU_DU;
  }

  private Parser<Company> vCompany = null;
  public Parser<Company> getVCompany(){
    if (vCompany==null){
      vCompany = new Element<Company>("Company"
     ,new Closure<Parser<Company>>(){public Parser<Company> eval(){return getVDept().star()
     .<Company>map(new Function1<List<Dept>,Company>(){
       public Company eval(List<Dept> x){
         return new Company(x);
       }
     })
;}}//end of closure
);
    }
    return vCompany;
  }

  private Parser<DU> vDU = null;
  public Parser<DU> getVDU(){
    if (vDU==null){
      vDU = new Element<DU>("DU"
     ,new Closure<Parser<DU>>(){public Parser<DU> eval(){return getVDept()
     .<DU>map(new Function1<Dept,DU>(){
       public DU eval(Dept x){
         return new DU(x);
       }
     })
;}}//end of closure
);
    }
    return vDU;
  }

  private Parser<Dept> vDept = null;
  public Parser<Dept> getVDept(){
    if (vDept==null){
      vDept = new Element<Dept>("Dept"
     ,new Closure<Parser<Dept>>(){public Parser<Dept> eval(){return getVName().seq(getVEmployee()).seq(getVChoice_PU_DU().star()).map(new Function1<Tuple2<Tuple2<Name,Employee>,List<Choice_PU_DU>>,Dept>(){
    public Dept eval(Tuple2<Tuple2<Name,Employee>,List<Choice_PU_DU>> p){
      return new Dept(p.e1.e1,p.e1.e2,p.e2);
    }
  })
;}}//end of closure
);
    }
    return vDept;
  }

  private Parser<Employee> vEmployee = null;
  public Parser<Employee> getVEmployee(){
    if (vEmployee==null){
      vEmployee = new Element<Employee>("Employee"
     ,new Closure<Parser<Employee>>(){public Parser<Employee> eval(){return getVPerson().seq(getVSalary()).map(new Function1<Tuple2<Person,Salary>,Employee>(){
    public Employee eval(Tuple2<Person,Salary> p){
      return new Employee(p.e1,p.e2);
    }
  })
;}}//end of closure
);
    }
    return vEmployee;
  }

  private Parser<Name> vName = null;
  public Parser<Name> getVName(){
    if (vName==null){
      vName = new Element<Name>("Name"
     ,new Closure<Parser<Name>>(){public Parser<Name> eval(){return new PCData()
     .<Name>map(new Function1<String,Name>(){
       public Name eval(String x){
         return new Name(x);
       }
     })
;}}//end of closure
);
    }
    return vName;
  }

  private Parser<PU> vPU = null;
  public Parser<PU> getVPU(){
    if (vPU==null){
      vPU = new Element<PU>("PU"
     ,new Closure<Parser<PU>>(){public Parser<PU> eval(){return getVEmployee()
     .<PU>map(new Function1<Employee,PU>(){
       public PU eval(Employee x){
         return new PU(x);
       }
     })
;}}//end of closure
);
    }
    return vPU;
  }

  private Parser<Person> vPerson = null;
  public Parser<Person> getVPerson(){
    if (vPerson==null){
      vPerson = new Element<Person>("Person"
     ,new Closure<Parser<Person>>(){public Parser<Person> eval(){return getVName().seq(getVAddress()).map(new Function1<Tuple2<Name,Address>,Person>(){
    public Person eval(Tuple2<Name,Address> p){
      return new Person(p.e1,p.e2);
    }
  })
;}}//end of closure
);
    }
    return vPerson;
  }

  private Parser<Salary> vSalary = null;
  public Parser<Salary> getVSalary(){
    if (vSalary==null){
      vSalary = new Element<Salary>("Salary"
     ,new Closure<Parser<Salary>>(){public Parser<Salary> eval(){return new PCData()
     .<Salary>map(new Function1<String,Salary>(){
       public Salary eval(String x){
         return new Salary(x);
       }
     })
;}}//end of closure
);
    }
    return vSalary;
  }}