package name.panitz.adt;

import java.util.*;
import java.io.*;
import com.sun.mirror.declaration.*;
import com.sun.mirror.apt.*;

public class ADT {

  String name;
  String thePackage;
  public List<Constructor> constructors;
  TypeDeclaration cd;
  final Filer filer;

  public ADT
    (AnnotationProcessorEnvironment env,TypeDeclaration cd){
      thePackage = cd.getPackage().getQualifiedName();
      name=cd.getSimpleName();
      constructors=new ArrayList<Constructor>();
      this.cd=cd;
      filer=env.getFiler();
  }

  public String getFullName(){return cd.toString();}
  public String getName(){return name;}
  String commaSepPs(){
    final String qN=getFullName();
    final int index=qN.indexOf('<');
    return index>=0?qN.substring(index+1,qN.length()-1):"";
  }
  public String getParamList(){
    return commaSepPs().length()==0?"":("<"+commaSepPs()+">");
  }
  String getPackageDef(){
    return  thePackage.length()==0?""
           :"package "+thePackage+";\n\n";
  }

  void addConstr(String n,Collection<ParameterDeclaration> ps){
   constructors.add(new Constructor(n,ps));
}

  public void generateClasses(){
    try{generateClass();
        generateVisitorClass();
        for (Constructor c:constructors)c.generateClass(this);
    }catch (IOException _){}}

  public void generateClass() throws IOException{
    final String fullName = getFullName();
    Writer out 
     = filer.createSourceFile(thePackage+"."+name+"Adt");

    out.write( getPackageDef());
    out.write("public abstract class ");
    out.write(getName()+"Adt"+getParamList());
    out.write(" extends "+fullName+"\n");
    out.write(" implements Iterable<Object>{\n");

    out.write("  abstract public <b_> b_ welcome("
            +name+"Visitor<" + commaSepPs()
                            +(commaSepPs().length()==0?"":",")
                            +"b_> visitor);\n");  
    out.write("}");
    out.close();
  }

  public void generateVisitorClass(){
    try{
      final String csName = name+"Visitor";	
      final String fullName
       = csName+"<"+commaSepPs()
                   +(commaSepPs().length()==0?"":",")+"result>";
      Writer out=filer.createSourceFile(thePackage+"."+csName);
      out.write( getPackageDef()+ "\n");
      out.write("public abstract class ");
      out.write(fullName+"{\n");
      for (Constructor c:constructors) 
        out.write("  "+c.mkVisitMethod(this)+"\n");

      out.write("  public result visit("+getFullName()+" xs){");
      out.write("\n    throw new RuntimeException(");
      out.write("\"unmatched pattern: \"+xs.getClass());\n");
      out.write("  }\n}");
      out.close();
    }catch (Exception _){}
  }

private class Constructor {

  String name;
  Collection<ParameterDeclaration> params;

  public Constructor
             (String n,Collection<ParameterDeclaration> ps){
    name=n;params=ps;}

  public void generateClass(ADT theType){
    try{
      Writer out
        = filer.createSourceFile(theType.thePackage+"."+name);
      out.write( theType.getPackageDef());
      out.write("public class "+name);
      out.write(theType.getParamList()+" extends ");
      out.write(theType.getName()+"Adt"+theType.getParamList());
      out.write("{\n");

      mkFields(out);
      mkConstructor(out);
      mkWelcomeMethod(theType, out);
      mkToStringMethod(out);
      mkEqualsMethod(out);
      mkIteratorMethod(out);
      out.write("}\n");out.close();
    }catch (Exception _){}
  }

  private void mkFields(Writer out)throws IOException{
    for (ParameterDeclaration p:params){
     out.write("  public "+p.getType().toString()+" ");
     out.write(p.getSimpleName());
     out.write(";\n");
    }
  }

  private void mkConstructor(Writer out)throws IOException{
    out.write("\n  public "+name+"(");
    boolean first= true;
    for (ParameterDeclaration p:params){
      if (!first){out.write(",");}
      out.write(p.getType().toString()+" ");
      out.write(p.getSimpleName());
      first=false;
    }
    out.write("){\n");
    for (ParameterDeclaration p:params){
      out.write("    this."+p.getSimpleName()+" = ");
      out.write(p.getSimpleName()+";\n");
    }
    out.write("  }\n\n");
  }

  private void mkWelcomeMethod(ADT theType,Writer out)
         throws IOException{
      out.write("  public <_b> _b welcome("
		+theType.name+"Visitor<"+theType.commaSepPs()
                      +(theType.commaSepPs().length()==0?"":",")
                                +"_b> visitor){"
                +"\n    return visitor.visit(this);\n  }\n"); 
  }

  private void mkToStringMethod(Writer out) throws IOException{
    out.write("  public String toString(){\n");
    out.write("    return \""+name+"(\"");
    boolean first=true;
    for (ParameterDeclaration p:params){
     if (first){first=false;}
     else out.write("+\",\"");
     out.write("+"+p.getSimpleName());
    }
    out.write("+\")\";\n  }\n"); 
  }

  private void mkEqualsMethod(Writer out) throws IOException{
    out.write("  public boolean equals(Object other){\n");
    out.write("    if (!(other instanceof "+name+")) ");
    out.write("return false;\n");
    out.write("    final "+name+" o= ("+name+") other;\n");
    out.write("    return true  ");
    for (ParameterDeclaration p:params){
      out.write("&& "+p.getSimpleName()
                     +".equals(o."+p.getSimpleName()+")");
    }
    out.write(";\n  }\n"); 
  }

  private void mkIteratorMethod(Writer out) throws IOException{
    out.write("  public java.util.Iterator<Object>iterator(){");
    out.write("\n    java.util.List<Object> res\n");
    out.write("         =new java.util.ArrayList<Object>();\n");
    for (ParameterDeclaration p:params)
      out.write("    res.add("+p.getSimpleName()+");\n");
    out.write("    return res.iterator();\n  }\n"); 
  }

  public String mkVisitMethod(ADT theType){
    return "public abstract result visit("
            +name+theType.getParamList()+" _);";
  }
}}

