package name.panitz.adt;
import com.sun.mirror.apt.*;
import com.sun.mirror.util.*;
import com.sun.mirror.declaration.*;
import java.util.*;
public class AdtGen extends SimpleDeclarationVisitor
                    implements AnnotationProcessor{
  Set<AnnotationTypeDeclaration> types;
  AnnotationProcessorEnvironment env;
  public AdtGen(Set<AnnotationTypeDeclaration> types
                 ,AnnotationProcessorEnvironment env){
    this.types=types;
    this.env=env;
    constrDeclaration = env.getTypeDeclaration(AdtGenFact.CONSTR_ANNOT);
    dataDeclaration = env.getTypeDeclaration(AdtGenFact.DATA_ANNOT);
  } 
  public void process(){
   for (TypeDeclaration td :env.getSpecifiedTypeDeclarations()){
      td.accept(this);
   }
  }

  final private TypeDeclaration constrDeclaration;
  final private TypeDeclaration dataDeclaration;

  boolean hasAnnot(TypeDeclaration a,Declaration m){
    for (AnnotationMirror am : m.getAnnotationMirrors()) 
      if(am.getAnnotationType().getDeclaration().equals(a))
        return true;
    return false;
  }

  public void visitClassDeclaration(ClassDeclaration d){
   if (hasAnnot(dataDeclaration,d)){
    ADT adt = new ADT(env,d); 
    for (MethodDeclaration m:d.getMethods()){
      if (hasAnnot(constrDeclaration,m)){ 
        adt.addConstr(m.getSimpleName(),m.getParameters());
      }
    }
    adt.generateClasses();   
  }}}

