package name.panitz.adt.examples;
import name.panitz.*;
import java.util.*;

public class ShowKlip extends KlipVisitor<String> {
  public String s(Klip a){return ((KlipAdt)a).welcome(this);}

  public String visit(Num x){return x.i.toString();}
  public String visit(Add x){return"("+s(x.e1)+"+"+s(x.e2)+")";}
  public String visit(Sub x){return"("+s(x.e1)+"-"+s(x.e2)+")";}
  public String visit(Div x){return"("+s(x.e1)+"/"+s(x.e2)+")";}
  public String visit(Mul x){return"("+s(x.e1)+"*"+s(x.e2)+")";}
  public String visit(Var v){return v.name;}
  public String visit(Assign x){return x.var+" := "+s(x.e);}
  public String visit(Block b){
    StringBuffer result=new StringBuffer();
    for (Klip x:b.stats)  result.append(s(x)+";\n");
    return result.toString();}
  public String visit(While w){
    StringBuffer result=new StringBuffer("while (");
    result.append(s(w.cond)+"){\n");
    result.append(s(w.body)+"\n}");
    return result.toString();}
}

