package name.panitz.animation;

import java.awt.Graphics;
import java.awt.Dimension;
import java.awt.Color;
import javax.swing.JFrame;

public class BouncingBall extends AnimatedJPanel {

  final int width = 100;
  final int height = 200;
  final int ballSize = 20;

  int yDir = 4;

  int ballX = width/2-ballSize/2;
  int ballY = 0;

  public void move(){
    if (ballY>height-ballSize || ballY<0) yDir=-yDir;
    ballY=ballY+yDir;
  }

  public void paintComponent(Graphics g){
    g.setColor(Color.RED);
    g.fillRect(0,0,width,height);
    g.setColor(Color.YELLOW);
    g.fillOval(ballX,ballY,ballSize,ballSize); 
  }

  public Dimension getPreferredSize(){
    return new Dimension(width,height);
  }

  public static void main(String [] _){
    JFrame f = new JFrame("");
    f.getContentPane().add(new BouncingBall());
    f.pack();
    f.setVisible(true);
  }
}

