package name.panitz.crempel.tool.apfel;

import java.awt.Graphics;
import java.awt.Color;
import java.awt.Dimension;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class Apfelmaennchen extends JPanel {

  final int width = 480;
  final int height = 430;

  double zelle=0.00625;

  final Color colAppleman = new Color(0,129,190);

  double startX = -2;
  double startY = -1.35;

  final int recDepth = 50;
  final int schwellwert = 4;

  //C-Werte checken nach zn+1 = zn*zn + c, 
  public int checkC(Complex c) {        
    Complex zn = new Complex(0,0);

    for (int n=0;n<recDepth;n=n+1) {
      final Complex znp1 = zn.mult(zn).add(c);
      if (znp1.norm() > schwellwert) return n;
      zn=znp1;
    }
    return recDepth;
  }

  public void paint(Graphics g) {
    for (int y=0;y<height;y=y+1) {
      for (int x=0;x<width;x=x+1) {

        final Complex current
          =new Complex(startX+x*zelle,startY+y*zelle);  

        final int iterationenC = checkC(current);

        paintColorPoint(x,y,iterationenC,g);
      }
    }
  }

  private void paintColorPoint
                 (int x,int y,int it,Graphics g){
    final Color col
      = it==recDepth
        ?colAppleman   
        :new Color(255-5*it%1,255-it%5*30,255-it%5* 50);
    g.setColor(col); 
    g.drawLine(x,y,x,y);
  }

  public Dimension getPreferredSize(){
    return new Dimension(width,height);
  }

  public static void main(String [] args){
    JFrame f = new JFrame();
    f.getContentPane().add(new Apfelmaennchen());
    f.pack();
    f.setVisible(true);
  }
}

