package name.panitz.crempel.util.xml.dtd.parser;

import java.io.*;
import java.util.*;
import name.panitz.crempel.util.*;
import name.panitz.crempel.util.xml.dtd.tree.*;
import name.panitz.crempel.util.xml.dtd.*;

public class MainDTDParse {
  public static void main(String [] args){
    try{
      final String dtdFileName = args[0];
      final String packageName = args[1].replace('/','.');

      File f = new File(dtdFileName);  
      final String path
          = f.getParentFile()==null?".":f.getParentFile().getPath();

      final DTD parser = new DTD(new FileReader(f));

      final Tuple3<List<Tuple2<String,DTDDef>>,List<String>,String> dtd
        = parser.dtd();

      for (Tuple2<String,DTDDef> t:dtd.e1){
        System.out.println(t.e1);
        System.out.println(t.e2);
        System.out.println("");
      }
 
      GenerateClassesForDTD
          .generateAll(packageName,path,dtd.e3,dtd.e1);
   }catch (Exception _){_.printStackTrace();System.out.println(_);} 
  }
}

