
package name.panitz.crempel.util.xml.dtd;
import name.panitz.crempel.util.xml.dtd.IsAtomic.*;
import name.panitz.crempel.util.xml.dtd.tree.*;
import name.panitz.crempel.util.Tuple3;
import name.panitz.crempel.util.Tuple2;
import name.panitz.crempel.util.Function1;
import java.util.List;
import java.util.ArrayList;
import java.util.TreeSet;
import java.util.Comparator;

public class DTDDefFlatten extends DTDDefVisitor<FlattenResult>{
  final String elementName;
  final boolean isGenerated;
  private int counter = 0;
  private String getNextName(){
    counter=counter+1;
    return elementName+"_"+counter;
  }

  public DTDDefFlatten(boolean g,String n){elementName=n;isGenerated=g;}

  public FlattenResult visit(DTDPCData x){
    return single(x);}
  public FlattenResult visit(DTDTagName x){
    return single(x);}
  public FlattenResult visit(DTDEmpty x){
    return single(x);}
  public FlattenResult visit(DTDAny x){
    return single(x);}
  public FlattenResult visit(DTDPlus x){
    if (IsAtomic.isAtomic(x.dtd)) return single(x);
    return flattenModified(elementName,x.dtd
          ,new Function1<DTDDef,DTDDef>(){
             public DTDDef eval(DTDDef dtd){return new DTDPlus(dtd);}
           });
  }
  public FlattenResult visit(DTDStar x){
    if (IsAtomic.isAtomic(x.dtd)) return single(x);
    return 
     flattenModified(elementName,x.dtd
          ,new Function1<DTDDef,DTDDef>(){
             public DTDDef eval(DTDDef dtd){return new DTDStar(dtd);}
           });
  }
  public FlattenResult visit(DTDQuery x){
    if (IsAtomic.isAtomic(x.dtd)) return single(x);
    return flattenModified(elementName,x.dtd
          ,new Function1<DTDDef,DTDDef>(){
             public DTDDef eval(DTDDef dtd){return new DTDQuery(dtd);}
           });
  }
  public FlattenResult visit(DTDSeq x){
    return flattenPartList(x.seqParts
          ,new Function1<List<DTDDef>,DTDDef>(){
             public DTDDef eval(List<DTDDef> dtds){
               return new DTDSeq(dtds);}
           });
  }
  public FlattenResult visit(DTDChoice x){
    return flattenPartList(x.choiceParts
          ,new Function1<List<DTDDef>,DTDDef>(){
             public DTDDef eval(List<DTDDef> dtds){
//System.out.println("the new choice"+dtds);
               return new DTDChoice(dtds);}
           });
   }

  private FlattenResult single(DTDDef x){return new FlattenResult(x);}

  private FlattenResult flattenModified
          (final String orgElem,DTDDef content
          ,Function1<DTDDef,DTDDef> constr){
    List<Tuple3<Boolean,String,DTDDef>> result 
     = new ArrayList<Tuple3<Boolean,String,DTDDef>>();
    if (needsNewElement(content)){
//    System.out.println("owo needs new element: "+content );
      final String newElemName
        = ShowType.typeToIdent(ShowType.sShowType(content));

      result.add(new Tuple3<Boolean,String,DTDDef>
         (true,newElemName,content));
      return new FlattenResult
                (constr.eval(new DTDTagName(newElemName)),result);
    } 
//    System.out.println("does not need new element");
    FlattenResult innerRes  = flatten(content);
//    System.out.println(innerRes);
    return new FlattenResult(constr.eval(innerRes.e1),innerRes.e2);
  }

  private FlattenResult flattenPartList
      (List<DTDDef> parts,Function1<List<DTDDef>,DTDDef> constr){
    final List<Tuple3<Boolean,String,DTDDef>> result 
      = new ArrayList<Tuple3<Boolean,String,DTDDef>>();
    if (parts.size()==1) {return single(parts.get(0));}

    List<DTDDef> newParts = new ArrayList<DTDDef>();    
    for (DTDDef part:parts){
      if (IsAtomic.isAtomic(part)) {//System.out.println("atomic part:"+part);
            newParts.add(part);}
      else if (needsNewElement(part)){
        final String newElemName
          = ShowType.typeToIdent(ShowType.sShowType(part));
        result.add(new Tuple3<Boolean,String,DTDDef>
             (true,newElemName,part));
        newParts.add(new DTDTagName(newElemName));
      }else{
        FlattenResult innerRes  = flatten(part);
        newParts.add(innerRes.e1);
        result.addAll(innerRes.e2);
      }
    } 
    return new FlattenResult(constr.eval(newParts),result);
  }

  static private boolean needsNewElement(DTDDef d){
    return 
     (d instanceof DTDSeq && ((DTDSeq)d).seqParts.size()>1)
            ||
     (d instanceof DTDChoice &&((DTDChoice)d).choiceParts.size()>1);
  }

  static public List<Tuple3<Boolean,String,DTDDef>> 
       flattenDefList(List<Tuple3<Boolean,String,DTDDef>> defs){
    boolean changed = true;
    List<Tuple3<Boolean,String,DTDDef>> result = defs;
    while (changed){
      Tuple2<Boolean,List<Tuple3<Boolean,String,DTDDef>>> once
        = flattenDefListOnce(result);
      changed=once.e1;
      result=once.e2;
    } 

    TreeSet<Tuple3<Boolean,String,DTDDef>> withoutDups
      = new TreeSet<Tuple3<Boolean,String,DTDDef>>(
         new Comparator<Tuple3<Boolean,String,DTDDef>>(){
           public int compare(Tuple3<Boolean,String,DTDDef> o1
                             ,Tuple3<Boolean,String,DTDDef> o2){
              return o1.e2.compareTo(o2.e2);
           }
         });
    withoutDups.addAll(result); 

    result = new ArrayList<Tuple3<Boolean,String,DTDDef>> ();
    result.addAll(withoutDups);
    return result;
  }

  private static Tuple2<Boolean,List<Tuple3<Boolean,String,DTDDef>>> 
       flattenDefListOnce(List<Tuple3<Boolean,String,DTDDef>> defs){

    final List<Tuple3<Boolean,String,DTDDef>> result
     = new ArrayList<Tuple3<Boolean,String,DTDDef>>();

    boolean changed = false;

    for (Tuple3<Boolean,String,DTDDef> def:defs){
      final FlattenResult singleResult
        = new DTDDefFlatten(def.e1,def.e2).flatten(def.e3);
      changed=changed||singleResult.e2.size()>0;
      result.addAll(singleResult.e2);
      result.add(
       new Tuple3<Boolean,String,DTDDef>(
         singleResult.e2.isEmpty()&&def.e1,def.e2,singleResult.e1));
    }
    return new Tuple2<Boolean,List<Tuple3<Boolean,String,DTDDef>>>
                  (changed,result); 
  }

  public static FlattenResult flatten(DTDDef def,String n){
   return new DTDDefFlatten(false,n).flatten(def);}

  public  FlattenResult flatten(DTDDef def){
   return ((DTDDefAdt)def).welcome(this);}
}



