
package name.panitz.crempel.util.xml.dtd;

import name.panitz.crempel.util.xml.dtd.tree.*;
import java.util.List;

public class DTDShow extends DTDDefVisitor<String>{
  public String show(DTDDef def){return ((DTDDefAdt)def).welcome(this);}

  public String visit(DTDPCData _){return "#PCDATA";};
  public String visit(DTDTagName x){return x.tagName;}
  public String visit(DTDEmpty x){return "Empty";}
  public String visit(DTDAny x){return "Any";}
  public String visit(DTDPlus x){return show(x.dtd)+"+";};
  public String visit(DTDStar x){return show(x.dtd)+"*";};
  public String visit(DTDQuery x){return show(x.dtd)+"?";};
  public String visit(DTDSeq s){
    return aux(this,",",s.seqParts);}
  public String visit(DTDChoice c){
    return aux(this,"|",c.choiceParts);}

  private String aux
              (DTDShow visitor,String sep,List<DTDDef> parts){
    StringBuffer result=new StringBuffer("(");
    boolean first = true; for (DTDDef x:parts){
      if (first) first=false; else result.append(sep);
      result.append(show(x));
    }
    result.append(")");
    return result.toString();
  }
}

