
package name.panitz.crempel.util.xml.dtd;

//import name.panitz.crempel.util.adt.parser.ADT;
import name.panitz.crempel.util.xml.dtd.tree.*;
import name.panitz.crempel.util.*;
//import name.panitz.crempel.util.adt.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Writer;
import java.io.StringReader;
import java.io.FileWriter;
import java.io.StringWriter;
import java.io.IOException;

public class GenerateADT extends DTDDefVisitor<String>{
  final String elementName;
  public GenerateADT(String e){elementName=e;}

  public String visit(DTDPCData x){
   return "  public @Constr void Con(String pcdata){}";}
  public String visit(DTDTagName x){
    final String typeName = ShowType.sShowType(x);
    return "  public @Constr void Con("+typeName+" the"+typeName+"){}";}
  public String visit(DTDEmpty x){return "";}
  public String visit(DTDAny x){return "";}
  public String visit(DTDPlus x){
    return "  public @Constr void Con(List<"+ShowType.sShowType(x.dtd)+"> xs){}";}
  public String visit(DTDStar x){
    return "  public @Constr void Con(List<"+ShowType.sShowType(x.dtd)+"> xs){}";}
  public String visit(DTDQuery x){
    return "  public @Constr void Con(Maybe<"+ShowType.sShowType(x.dtd)+"> xs){}";}
  public String visit(DTDSeq x){
    StringBuffer result = new StringBuffer("public @Constr void Con(");
    boolean first = true;
    for (DTDDef dtd :x.seqParts){
      if (!first) result.append(","); 
      final String typeName = ShowType.sShowType(dtd);
      result.append(typeName+" the"+ShowType.typeToIdent(typeName));

      first=false;
    }
    result.append("){}");
    return result.toString();
  }
  public String visit(DTDChoice x){
    StringBuffer result = new StringBuffer();
    for (DTDDef dtd :x.choiceParts){
      String typeName = ShowType.sShowType(dtd);
      final String varName = ShowType.typeToIdent(typeName);

      result.append("\n  public @Constr void C"+elementName+varName
                             +"("+typeName+" the"+varName+"){}");
    }
    return result.toString();
  }

  public static String generateADT(String element,DTDDef def){
   return ((DTDDefAdt)def).welcome(new GenerateADT(element));}

  public static void  generateADT
     (String paket,String path,List<Tuple3<Boolean,String,DTDDef>> xs){
    try {
      for (Tuple3<Boolean,String,DTDDef>x:xs){
        Writer out = new FileWriter(path+"/"+x.e2+".java");
        out.write("package "+paket+";\n");
        out.write("import java.util.List;\n");
        out.write("import name.panitz.crempel.util.Maybe;\n");
        out.write("import name.panitz.adt.*;\n");
        out.write("public @Data class "+x.e2+"{\n");
        out.write(generateADT(x.e2,x.e3));
        out.write("}");
        out.close();
       }
      }catch (Exception e){e.printStackTrace();}
  }
}

