
package name.panitz.crempel.util.xml.dtd;

import name.panitz.crempel.util.xml.dtd.tree.*;
import name.panitz.crempel.util.*;
//import name.panitz.crempel.util.adt.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Writer;
import java.io.StringWriter;
import java.io.IOException;

public class ParserCode extends DTDDefVisitor<String>{
  final String elementName;
  public ParserCode(String e){elementName=e;}

  public String visit(DTDPCData x){return "new PCData()";}
  public String visit(DTDTagName x){return "getV"+x.tagName+"()";}
  public String visit(DTDEmpty x){return "new Return(null)";}
  public String visit(DTDAny x){return null;}
  public String visit(DTDPlus x){return parserCode(x.dtd)+".plus()";}
  public String visit(DTDStar x){return parserCode(x.dtd)+".star()";}
  public String visit(DTDQuery x){return parserCode(x.dtd)+".query()";}
  public String visit(DTDSeq x){
    StringBuffer result = new StringBuffer();
    boolean first = true;
    for (DTDDef dtd:(List<DTDDef>) x.seqParts){
      if (!first){result.append(".seq(");}
      result.append(parserCode(dtd));
      if (!first){result.append(")");}
      first=false;
    }
    return result.toString();
  }

  public String visit(DTDChoice x){
    final List<DTDDef> xs =  x.choiceParts;
    if (xs.size()==1) {
      final DTDDef ch = xs.get(0);
      final String s  = parserCode(ch);
      return s;
    }
    StringBuffer result = new StringBuffer();
    boolean first = true;
    for (DTDDef dtd:xs){
      final String argType = ShowType.sShowType(dtd);
      final String resType = elementName;
      if (!first){result.append(".choice(");}
      result.append(parserCode(dtd));
      result.append(".<"+resType+">map(new Function1<");
      result.append(argType);
      result.append(",");
      result.append(resType);
      result.append(">(){");
      result.append("\n    public "+resType+" eval("+argType+" x){");
   
      String typeName = ShowType.sShowType(dtd);
      final String varName = ShowType.typeToIdent(typeName);
      result.append("\n      return ("+resType+")new C"
             +elementName+varName
             +"(x);");
      result.append("\n    }");
      result.append("\n  })");
      if (!first){result.append(")");}
      first=false;
    }
    return result.toString();
  }

  public String parserCode(DTDDef def){
    return ((DTDDefAdt)def).welcome(this);}

  public static String parserCode(DTDDef def,String n){
   return new ParserCode(n).parserCode(def);}
}

