
package name.panitz.crempel.util.xml.dtd;

import name.panitz.crempel.util.xml.dtd.tree.*;
import name.panitz.crempel.util.*;
import java.util.List;
import java.util.ArrayList;

public class ShowType extends DTDDefVisitor<String>{
  public String visit(DTDPCData x){return "String";}
  public String visit(DTDTagName x){return x.tagName;}
  public String visit(DTDEmpty x){return "Object";}
  public String visit(DTDAny x){return "Object";}
  public String visit(DTDPlus x){return "List<"+showType(x.dtd)+">";}
  public String visit(DTDStar x){return "List<"+showType(x.dtd)+">";}
  public String visit(DTDQuery x){return "Maybe<"+showType(x.dtd)+">";}
  public String visit(DTDSeq x){
    return listAsType((List<DTDDef>) x.seqParts);}

  public String visit(DTDChoice x){
    List<DTDDef> parts = x.choiceParts;
    if (parts.size()==1) return showType(parts.get(0));
    StringBuffer result=new StringBuffer("Choice");
    for (DTDDef y:((List<DTDDef>) parts))
      result.append("_"+typeToIdent(showType(y)));
    return result.toString();
  }

  private  String listAsType(List<DTDDef> xs){
    int size=xs.size();

    if (size==1) return showType(xs.get(0));
    StringBuffer result = new StringBuffer();
    for (Integer i:new FromTo(2,size)){
      result.append("Tuple2<");
    }
    boolean first=true;
    for (DTDDef dtd:xs){
      if (!first) result.append(",");
      result.append(showType(dtd));
      if (!first) result.append(">");
      first=false; 
    }
    return result.toString();       
  }

  public  String showType(DTDDef def){
    return ((DTDDefAdt)def).welcome(this);}

  public  static String sShowType(DTDDef def){
    return new ShowType().showType(def);}

  static public String typeToIdent(String s ){
    return s.replace('<','_').replace('>','_').replace('.','_');
  }
}

