package name.panitz.crempel.util.xml.dtd;

import name.panitz.crempel.util.xml.dtd.tree.*;
import name.panitz.crempel.util.*;
//import name.panitz.crempel.util.adt.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Writer;
import java.io.StringWriter;
import java.io.IOException;

public class WriteParser extends DTDDefVisitor<String>{
  final String elementName;
  final boolean isGenerated  ;
  String contentType = null;
  String typeDef = null;
  String fieldName = null;
  String getterName = null;

  public WriteParser(String e,boolean g){elementName=e;isGenerated=g;}

  private void start(DTDDef def,StringBuffer result){
    contentType = ShowType.sShowType(def);
    typeDef = !isGenerated?elementName:contentType;
    fieldName = "v"+elementName;  
    getterName = "getV"+elementName+"()";  

    result.append("\n\n  private Parser<"+typeDef+"> "+fieldName+" = null;"); 
    result.append("\n  public Parser<"+typeDef+"> "+getterName+"{"); 
    result.append("\n    if ("+fieldName+"==null){"); 
    result.append("\n      "+fieldName+" = ");
    if (!isGenerated) {
      result.append("new Element<"+typeDef+">(\""+typeDef+"\"");
      result.append("\n     ,");
      result.append("new Closure<Parser<"+typeDef+">>(){public Parser<"+typeDef+"> eval(){return ");      
    }

  }

  private String f(DTDDef def){
    StringBuffer result=new StringBuffer();
    start(def,result);
    result.append(ParserCode.parserCode(def,elementName));
    if (!isGenerated){
      result.append("\n     .<"+typeDef+">map(new Function1");
      result.append("<"+contentType+","+typeDef+">(){");
      result.append("\n       public "+typeDef+" eval("+contentType+" x){");
      result.append("\n         return new "+typeDef+"(x);");
      result.append("\n       }");
      result.append("\n     })");
    } 
    end(def,result);
    return result.toString();
  }

  private void end(DTDDef def,StringBuffer result){
    if (!isGenerated){
      result.append("\n;}}//end of closure\n"); 
      result.append(")");     

    }
    result.append(";"); 
    result.append("\n    }"); 
    result.append("\n    return "+fieldName+";"); 
    result.append("\n  }");
  }

  private String startend(DTDDef def){
    StringBuffer result=new StringBuffer();
    start(def,result);
    result.append(ParserCode.parserCode(def,elementName));
    end(def,result);
    return result.toString();
  }

  public String visit(DTDPCData x){return f(x);}
  public String visit(DTDTagName x){return f(x);}
  public String visit(DTDEmpty x){return f(x);}
  public String visit(DTDAny x){return null;}
  public String visit(DTDPlus x){return f(x);}
  public String visit(DTDStar x){return f(x);}
  public String visit(DTDQuery x){return f(x);}
  public String visit(DTDChoice x){return startend(x);}
  public String visit(DTDSeq x){
    StringBuffer result = new StringBuffer();
    start(x,result);
    result.append(ParserCode.parserCode(x,elementName));
    result.append(".map(new Function1<"
                 +ShowType.sShowType(x)+","+elementName+">(){");
    result.append("\n    public "+elementName);
    result.append(" eval("+ShowType.sShowType(x) +" p){");
    result.append("\n      return new "+elementName);
    unrollPairs(x.seqParts.size(),"p",result);
    result.append(";");
    result.append("\n    }");
    result.append("\n  }");
    result.append(")");
    end(x,result);
    return result.toString();
  }

  private void unrollPairs(int i,String var,StringBuffer r){
    String c = var;
    String result="";
    for (Integer j :new FromTo(2,i)){
       result=","+c+".e2"+result;
       c= c+".e1";
    }
    result=c+result;
    r.append("(");
    r.append(result);
    r.append(")");
  }

  public static String writeParser
                      (DTDDef def,String n,boolean isGenerated){
    return new WriteParser(n,isGenerated).writeParser(def);}

  public  String writeParser(DTDDef def){
    return ((DTDDefAdt)def).welcome(this);}
}

