package name.panitz.crempel.util.xml.parslib;

import java.util.List;
import java.util.ArrayList;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

import name.panitz.crempel.util.Closure;


public class Element<a> extends AbstractParser<a> {
  Parser<a> p=null;
  private final Closure<Parser<a>> pc;
  final String elementName;

  public Element(String n,Parser<a> _p){elementName=n;p=_p;pc=null;}
  public Element(String n,Closure<Parser<a>> _p){elementName=n;pc=_p;}

  public Parser<a> getP(){if (p==null) p=pc.eval(); return p;}

  public ParseResult<a> parse(List<Node> xs){
    if (xs.isEmpty()) {return new Fail<a>(xs);}
    Node x = xs.get(0);
    while (   x.getNodeType()==Node.TEXT_NODE
           && x.getNodeValue().trim().length()==0
          ){
      xs=xs.subList(1,xs.size());
      if (xs.isEmpty()) return new Fail<a>(xs);  

      x = xs.get(0);
    }

    final String name = x.getNodeName();
System.out.println(name+" <-> "+elementName);
    if (!name.equals(elementName)) 
      return new Fail<a>(xs);

    final List<Node> ys = nodelistToList(x.getChildNodes());
    ParseResult<a> res = getP().parse(ys);

    if( res.failed()) return new Fail<a>(xs); 

    for (Node y :res.e2){
      if (y.getNodeType()!=Node.TEXT_NODE 
             || y.getNodeValue().trim().length()!=0)
         return new Fail<a>(xs);
    }

    return new ParseResult<a>(res.e1,xs.subList(1,xs.size()));    
  }

  static public List<Node> nodelistToList(NodeList xs){
    List<Node> result = new ArrayList<Node>();
    for (int i=0;i<xs.getLength();i=i+1){
      result.add(xs.item(i));
    }
    return result;
  }
}

