package name.panitz.data.list;
class Li<a> implements Iterable<a>{
  boolean empty = true;
  a  hd;
  Li<a> tl;
 
  Li(){}

  Li(a x,Li<a> xs){
   hd = x;
   tl = xs;
   empty = false;
  }

  boolean isEmpty() {return empty;}  
  a  head(){return hd;}
  Li<a>      tail(){return tl;}

  public java.util.Iterator<a> iterator(){
    final Li<a>  itout = this;
    return new java.util.Iterator<a>(){
      Li<a>  it = itout;
      public boolean hasNext(){return !it.isEmpty();}
      public a next(){a result=it.head();it=it.tail();return result;}
      public void remove(){throw new UnsupportedOperationException();}
    };
  }  


  public Li(a... xs){
    this(0,xs);
  }

  private Li(int i,a... xs){
    if (i<xs.length) {
      empty=false;
      hd=xs[i];
      tl = new Li<a>(i+1,xs);
    }
  }


  int length(){
    if (isEmpty())return 0;
    return 1+tail().length();
  }

  int lengthWhile(){
    int erg=0;
    Li<a> xs = this;
    while (!xs.isEmpty()){
      erg= erg +1;
      xs = xs.tail();
    }
    return erg;
  }

  int lengthFor(){
    int erg=0;
    for (Li<a> xs=this;!xs.isEmpty();xs=xs.tail()){
      erg = erg +1;
    }
    return erg;
  }

  public String toString(){
    return "("+toStringAux()+")";
  }

  private String toStringAux(){
    if (isEmpty()) return "";
    else if (tail().isEmpty()) return head().toString();
    else return head().toString()+","+tail().toStringAux();
  }

Li<a> append(Li<a> ys){
  if (isEmpty())return ys;
  return new Li<a>(head(),tail().append(ys));
}

  Li<a> filter(FilterCondition<a> cond){
    Li<a> result = new Li<a>(); 

    //test all elements of this list
    for (Li<a> xs=this;!xs.isEmpty();xs=xs.tail()){

      //in case that the condition is true for the element
      if (cond.condition(xs.head())) {
        //then add it to the result
        result = new Li<a>(xs.head(),result);
      }
    }
    return result;
  }

  static public <a extends Comparable<a>> Li<a> quicksort(Li<a> xs){
    Li<a> result = new Li<a>();
    if (!xs.isEmpty()){ 
      result 
       = //filter the smaller elements out of the tail
         //and sort these
         quicksort(xs.tail().filter(new LessEqualX<a>(xs.head())))
          //concatenate it with the sorted 
          //sublist of greater elements
          .append(new Li<a>(xs.head()
                 ,quicksort(xs.tail().filter(new GreaterX<a>(xs.head())))
            ));
    }
    return result;
  }

  Li<a> sortBy(Relation<a,a>  rel){
    Li<a> result = new Li<a>();
    if (!isEmpty()){ 
      FilterCondition<a> le
       = new OrderingCondition<a>(head(),rel);
      FilterCondition <a> gr
       = new NegativeOrderingCondition<a>(head(),rel);
      result = tail()
                .filter(le)
                .sortBy(rel)
                .append(new Li<a>(head()
                                 ,tail()
                                 .filter(gr)
                                 .sortBy(rel)));
    }
    return result;
  }
}

