package name.panitz.data.tree; 

import java.util.List;
import java.util.ArrayList;

public class BinTree<a> extends Tree<a>{

  //private Felder für rechtes und linkes Kind
  private BinTree<a> rght;
  private BinTree<a> lft;

  public BinTree(BinTree<a> left,a mark,BinTree<a> right){
    super(mark);lft=left; rght=right;} 

  public BinTree(a mark){this(null,mark,null);}

  public BinTree<a> left(){return lft;}
  public BinTree<a> right(){return rght;}

  public List<Tree<a>> theChildren(){
    List<Tree<a>> result = new ArrayList<Tree<a>>();
    if (left()!=null)  result.add(left());
    if (right()!=null) result.add(right());
    return result;
  }

public void addLeaf(a o){
    throw new UnsupportedOperationException();
}

public void deleteChild(int n){
  if (n==0) lft=null;
  else if (n==1) rght=null;
  else throw new IndexOutOfBoundsException ();
}

  void setLeft(BinTree<a> l){ lft=l;}
  void setRight(BinTree<a> r){ rght=r;}

public List<a> inorder(){
  //Ergebnisliste
  List<a> result = new ArrayList<a>();
 
  //gibt es ein linkes Kind, füge dessen 
  //Linearisierung hinzu
  if (left()!=null) result.addAll(left().inorder());

  //dann den Knoten selbst
  result.add(mark());

  //und gegebenenfalls dann das recte Kind
  if (right()!=null) result.addAll(right().inorder());

  return result;
}

public List military(){
  //Ergebnisliste enthält erst diesen Knoten
  List<a> result=new ArrayList<a>();
  result.add(mark());

  //Wir speichern uns die Knoten einer 
  //aktuellen Generation
  List<Tree<a>> currentGeneration = theChildren();

  //Solange es in der aktuellen Generation Knoten gibt
  while (!currentGeneration.isEmpty()){
    //erzeuge die nächste Generation
    List<Tree<a>> nextGeneration=new ArrayList<Tree<a>>();

    for (Tree<a> nextChild:currentGeneration){
      nextGeneration.addAll(nextChild.theChildren());

      //Füge das Elemente der aktuellen Generation 
      //zum Ergebnis
      result.add(nextChild.mark());
    }
    //schalte eine Generation tiefer
    currentGeneration=nextGeneration;
  } 
  return result;
}}

