package name.panitz.data.tree;

import java.util.Enumeration;

import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.tree.TreeNode;

import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Dimension;

public class DisplayTree extends JPanel{

  private TreeNode treeModell;

  static final public int VERTICAL_SPACE = 50;  
  static final public int HORIZONTAL_SPACE = 20;

    private FontMetrics fontMetrics = null;

  private int height=0;
  private int width=0;

  private boolean dimensionCalculated = false;

  public DisplayTree(TreeNode tree){treeModell=tree;}

  public DisplayTree(TreeNode t,FontMetrics fm){
    treeModell=t;fontMetrics=fm;
  }

  private void calculateDimension(){


    if (fontMetrics==null){
      final Font font = getFont();
      fontMetrics = getFontMetrics(font);
    }

    final int x
      = fontMetrics.stringWidth(treeModell.toString());


    final Dimension childrenDim = childrenSize();
    final int childrenX = (int)childrenDim.getWidth();
    final int childrenY = (int)childrenDim.getHeight();

    width=x>childrenX?x:childrenX;

    height
      =  childrenY == 0
        ?fontMetrics.getHeight()
        :VERTICAL_SPACE+childrenY;

    dimensionCalculated = true;
  }

  Dimension childrenSize(){
    int x = 0;
    int y = 0;

    final Enumeration<TreeNode> it=treeModell.children();
    while (it.hasMoreElements()){
      final DisplayTree t
       = new DisplayTree(it.nextElement(),fontMetrics);

      y =  y > t.getHeight()?y:t.getHeight();

      x=x+t.getWidth();

      if (it.hasMoreElements())  x=x+HORIZONTAL_SPACE;
    }
    return new Dimension(x,y);
  }

  public int getHeight(){
    if (!dimensionCalculated) calculateDimension();
    return height;
  }

  public int getWidth(){
    if (!dimensionCalculated) calculateDimension();
    return width;
  }

  public Dimension getSize(){
    if (!dimensionCalculated) calculateDimension();
    return new Dimension(width,height);
  }

  public Dimension getMinimumSize(){
    return getSize();
  }

  public Dimension getPreferredSize(){
    return getSize();
  }

  public void paintComponent(Graphics g){paintAt(g,0,0);}

  public void paintAt(Graphics g,int x,int y){
    fontMetrics = g.getFontMetrics();
    final String marks =treeModell.toString();

    g.drawString
     (marks
     ,x+(getWidth()/2-fontMetrics.stringWidth(marks)/2)
     ,y+10);

    final int startLineX = x+getWidth()/2;
    final int startLineY = y+10;

    final Enumeration it=treeModell.children();

    final int childrenWidth = (int)childrenSize().getWidth();

    //wieviel nach rechts zu rücken ist
    int newX
      = getWidth()>childrenWidth?(getWidth()-childrenWidth)/2:0;

    //die y-Koordinate der Kinder
    final int nextY = y+VERTICAL_SPACE;

    while (it.hasMoreElements()){
      DisplayTree t
       = new DisplayTree((TreeNode)it.nextElement());

      //x-Positionen für das nächste Kind
      final int nextX = x+newX;
 
      //zeichne das Kind
      t.paintAt(g,nextX,nextY);

      //zeichne Kante
      g.drawLine(startLineX,startLineY
                ,nextX+t.getWidth()/2,nextY);

      newX = newX+t.getWidth()+HORIZONTAL_SPACE;
    }
  }
}

