package name.panitz.data.tree;

public class SearchTree<a extends Comparable<a>> 
                                  extends BinTree<a>{

  SearchTree(a o){super(o);}

  public void insert(a o){
    if (o.compareTo(mark())<=0){
      //neuer Knoten ist kneiner, also in den 
      //linken Teilbaum
      if (left()==null){
        setLeft(new SearchTree<a>(o));
      }else 
        ((SearchTree<a>)left()).insert(o);
    }else{
      //wenn der neue Knoten also größer, dann dasselbe
      //im rechten Teilbaum
      if (right()==null){
         setRight(new SearchTree<a>(o));
      }else 
        ((SearchTree<a>)right()).insert(o);
    }
  }


private SearchTree
           (SearchTree<a> l,a o,SearchTree<a> r){
  super(l,o,r);
  try {
   if (!(   o.compareTo(l.mark())>=0
         && o.compareTo(r.mark())<=0))
     throw new IllegalArgumentException
     ("ordering violation in search tree construction");
  }catch(NullPointerException _){
  }
}

public boolean contains(a o){
  //bist du es schon selbst
  if (mark().equals(o)) return true;
 
  //links oder rechts suchen:
  final int compRes = mark().compareTo(o);

  if (compRes>0){
    //keine Knoten mehr. Dann ist er nicht enthalten
    if (left()==null) return false;
    //Sonst such weiter unten im Baum
    else return ((SearchTree<a>)left()).contains(o);
  }    

  if (compRes<0){
    if (right()==null) return false;
    else return ((SearchTree<a>)right()).contains(o);
  }    
  return false;
}

public static <a extends Comparable<a>> SearchTree<a> 
                         rotateRight(SearchTree<a> t){
  try{
    //speichere die einzelnen Teile in die Bezeichner,
    //die wir in der Spezifikation benutzt haben
    final SearchTree<a> l2 = (SearchTree<a>)t.left().left();
    final SearchTree<a> r2 = (SearchTree<a>)t.left().right();
    final SearchTree<a> r1 = (SearchTree<a>)t.right();
    final a x1 = t.mark();
    final a x2 = t.left().mark();

    return new SearchTree<a>
                 (l2,x2,new SearchTree<a>(r2,x1,r1));
  }catch (NullPointerException _){
      return t;
  }
}

void rotateRight(){
  try{
    BinTree<a> l1 = left();
    BinTree<a> l2 = l1.left();
    BinTree<a> r2 = l1.right();
    BinTree<a> r1 = right();
    a  x1 = mark();
    a  x2 = l1.mark();

    setMark(x2);
    setLeft(l2);
    setRight(l1);
    l1.setMark(x1);
    l1.setLeft(r2);
    l1.setRight(r1);
  }catch (NullPointerException _){
  }
}}

