package name.panitz.data.tree;

import java.util.List;
import java.util.Iterator;
import java.util.Enumeration;
import java.util.ArrayList;
import javax.swing.tree.TreeNode; 

public class Tree<a> implements TreeNode{

  private a mrk;  
  private List<Tree<a>> chldrn;

  public Tree(List<Tree<a>> children){
    this(null,children);
  }

  public Tree(a mark){
    this(mark,new ArrayList<Tree<a>>());
  }


  public List<Tree<a>> theChildren(){return chldrn;}
  public a mark(){return mrk;}

  public boolean isLeaf(){return theChildren().isEmpty();}


public int count(){
  int result = 1; // Startwert 1 für diesen Knoten

  //für jedes Kind
  for (Tree<a> child: theChildren())
    //addiere die Knotenanzahl des Kindes zum Ergebnis 
    result=result+child.count();

  return result;
}

public List<a> flatten(){
  //leere Liste für das Ergebnis
  List<a> result = new ArrayList<a>();

  //füge die Markierung dieses Knotens zur 
  //Ergebnisliste hinzu
  result.add(mark());

  //für jedes Kind
  for (Tree<a> child : theChildren())
    //erzeuge dessen Knotenliste und füge alle deren 
    //Elemente zum Ergebnis hinzu
    result.addAll(child.flatten());

  return result;
}

public List<a> leaves(){
  //leere Liste für das Ergebnis
  List<a> result = new ArrayList<a>();

  //füge die Markierung dieses Knotens zur Ergebnisliste 
  //nur hinzu, wenn es ein Blatt ist
  if (isLeaf()) result.add(mark());

  //für jedes Kind
  for (Tree<a> child:theChildren())
    //erzeuge dessen Knotenliste und füge alle deren Blätter 
    //zum Ergebnis hinzu
    result.addAll(child.leaves());

  return result;
}

public List<a> flatten(List<a> result){
  result.add(mark());

  for (Tree<a> child:theChildren())
    child.flatten(result);

  return result;
}

public List<a> flattenAkk(){
  return flatten(new ArrayList<a>());
}

public List<a> leaves(List<a> result){
  if (isLeaf()) result.add(mark());

  for (Tree<a> child:theChildren())
    child.leaves(result);

  return result;
}

public List<a> leavesAkk(){
  return leaves(new ArrayList<a>());
}

public List<a> filter(List<a> result,TreeCondition<a> c){
  //wenn die Bedingung für den Knoten wahr ist, füge
  //ihm dem Ergebnis hinzu
  if (c.takeThis(this)) result.add(mark());

  //für alle Kinder
  for (Tree<a> child:theChildren())
    //rufe den Filter mit gleicher Bedingung auf
    child.filter(result,c);
  
  return result;
}

public List<a> filter(TreeCondition<a> c){
  return filter(new ArrayList<a>(),c);
}

public List leavesFilter(){
  return filter(
     new TreeCondition<a>(){
        public boolean takeThis(Tree<a> t){
          return t.isLeaf();
        }
     });
}

public List<a> flattenFilter(){
  return filter(new TreeCondition<a>(){
                  public boolean takeThis(Tree<a> _){return true;}
                });
}

public List<a> nodesWithTwoChildren(){
  return filter(new TreeCondition<a>(){
                  public boolean takeThis(Tree<a> t){
                    return t.theChildren().size()==2;
                  }
                });
}

public List<a> nodesMarkedWith(final a o){
  return filter(new TreeCondition<a>(){
                  public boolean takeThis(Tree<a> t){
                    return t.mark().equals(o);
                  }
                });
}

public boolean containsFilter(a o){
  return !nodesMarkedWith(o).isEmpty();
}

  public String show(String indent){
    //zeige diesen Knoten mit Einrückung
    String result = indent+mark();

    //erhöhe die Einrückung
    indent=indent+"  ";

    //für jedes Kind
    for (Tree<a> child:theChildren())
     //erzeuge neue Zeile und zeige Kind mit neuer Einrückung
      result=result+"\n"+child.show(indent);
    
    return result;
  }

  public String show(){
      return show("");
  }

  public StringBuffer show(String indent,StringBuffer result){
    //zeige diesen Knoten mit Einrückung
    result.append(indent);
    result.append(mark().toString());

    //erhöhe die Einrückung
    indent=indent+"  ";

    //für jedes Kind
    for (Tree<a> child:theChildren()){
     //erzeuge neue Zeile und zeige Kind mit neuer Einrückung
      result.append("\n");
      child.show(indent,result);
    }
    return result;
  }

  public String showAkk(){
      return show("",new StringBuffer()).toString();
  }

  public boolean contains(a o){
    //bin ich schon der gesuchte Knoten? Wenn ja ende mit erfolg
    if (mark().equals(o)) return true;

    //für jedes Kind
   for (Tree<a> child:theChildren()){
      //wenn es den Knoten enthält, beende mit erfolg
      if (child.contains(o)) return true;
    }
    //keiner der Knoten enthielt das Objekt
    return false;
  }

  public int maxDepth(){
    //anfangstiefe
    int result = 0;

    //für jedes Kind
   for (Tree<a> child:theChildren()){
      //berechne seine maximale Tiefe
      int n = child.maxDepth();

      //ist sie höher als die bisher gefundene, dann nimm diese
      if (n>result) result=n;
    } 

    //erhöhe Ergebnis um eins für die Wurzel
    return result+1;
  }

  public List<a> getPathBad(a o){
    List<a> result = new ArrayList<a>();

  //wenn Du irgendwo das Objekt enthältst, liegst Du auf den Pfad
    if (contains(o)) { result.add(mark());}

    //für jedes Kind
   for (Tree<a> child:theChildren()){
      //füge den Pfad zum fraglichen Objekt hinzu
      result.addAll(child.getPathBad(o));
    }
    return result;
  }

public List<a> getPathFilter(final a o){
   return filter(
      new TreeCondition<a>(){
        public boolean takeThis(Tree<a> e){
          return e.contains(o);
        }  
      }
   );
}

  public List<a> getPath(a o,List<a> result){
    //bist Du selbst der Knoten, 
    //dann ende mit der einelementigen Liste
    if (mark().equals(o)) { result.add(mark()); return result;}

   for (Tree<a> child:theChildren()){
      //berechne Pfad vom Kind zum Objekt 
      final List<a> path = child.getPath(o,result);

      //Kind hat einen solchen Pfad
      if (!path.isEmpty()){
        //hänge Dich vorne dran
        result.add(0,mark());
        //und fertig
        return result;
      }
    }
    return result;
  }

  public Iterator<a> iterator(){
      return flatten().iterator();  
  }

  public <b> boolean sameStructure(Tree<b> other){
    //haben beide Bäume gleich viel Kinder. 
    if(this.theChildren().size()!=other.theChildren().size())
        //wenn nein, dann sind sie nicht strukturgleich
        return false;

    //Iteriere über die Kinder beider Bäume
    Iterator<Tree<a>> it1=this.theChildren().iterator();
    Iterator<Tree<b>> it2=other.theChildren().iterator();

    //solange es noch Kinder gibt
    while (it1.hasNext()){
      //hohle das nächste Kind beider Bäume
      final Tree<a> thisChild = it1.next();
      final Tree<b> otherChild =it2.next();

      //sind diese nicht strukturgleich, dann breche ab
      if (!thisChild.sameStructure(otherChild)) return false;
    }
    
    //die Strukturgleichheit wurde nie verletzt
    return true;
  }

  public <b> boolean equals(Tree<b> other){
      if (!this.sameStructure(other)) return false;
      return this.flatten().equals(other.flatten());
  }

  public boolean equals(Object other){
      if (! (other instanceof Tree)) return false;
      Tree<?> o = (Tree<?>) other;
      return this.equals(o);
  }


  public Tree<a> parent=null;


  public Tree(a mark,List<Tree<a>> children){
    //setze die entsprechenden Felder des Knotens
    this.mrk=mark;
    this.chldrn=children;

    //es gibt noch keinen Elternknoten
    this.parent=null;

    //setze den neuen Knoten als Elternknoten der Kinder
    respectParents();  
  }

 public void respectParents(){
   //für jedes Kind
   for (Tree<a> child:theChildren()){
    // ist dieser Knoten jetzt der Elternknoten
    child.parent=this;
   }
 }

public void addChild(Tree<a> newChild){
  List<Tree<a>> chs = theChildren();
  newChild.parent=this;
  chs.add(newChild);
}

public void addLeaf(a o){addChild(new Tree<a>(o));}

public void deleteChild(int n){
   theChildren().remove(n);    
}

public void setMark(a mark){mrk=mark;}

  public Enumeration<TreeNode> children() {
    final Iterator<Tree<a>> it = theChildren().iterator();

    return new Enumeration<TreeNode>(){
      public boolean hasMoreElements(){return it.hasNext();} 
      public Tree<a> nextElement() {return it.next();}
    };
  }

  public TreeNode getChildAt(int childIndex) {
    return theChildren().get(childIndex);
  }

  public int getChildCount(){return theChildren().size();}

  public TreeNode getParent(){return parent;}

  public boolean getAllowsChildren(){
    throw new UnsupportedOperationException();
  } 

  public int getIndex(TreeNode node) {
    throw new UnsupportedOperationException();
  }

  public String toString(){return mark().toString();}}

