package name.panitz.dialoguegui;
import java.awt.event.*;
import java.awt.*;
import javax.swing.*;
import javax.swing.plaf.basic.*; 
import javax.swing.text.*; 
import javax.swing.text.html.*; 

public class HtmlDialogue extends JFrame{
  final DialogueLogics logic; 
  final JButton button;
  final JTextField inputField = new JTextField(20) ;
  final JTextPane outputField = new JTextPane();
  final JPanel p = new JPanel();

  public HtmlDialogue(DialogueLogics l){
    outputField.setEditorKit(new HTMLEditorKit());
    logic = l;
    button=new JButton(logic.getDescription());
    button.addActionListener
     (new ActionListener(){
        public void actionPerformed(ActionEvent _){
          logic.eval(inputField.getText().trim());
          outputField.setText(logic.toHTMLString());
          pack();
        }
      });

    p.setLayout(new BorderLayout());
    p.add(inputField,BorderLayout.NORTH);
    p.add(button,BorderLayout.CENTER);
    p.add(outputField,BorderLayout.SOUTH);
    getContentPane().add(p);
    pack();
    setVisible(true);
  }
}

