package name.panitz.games;

import name.panitz.animation.AnimatedJPanel;
import java.awt.Graphics;
import java.awt.event.*;
import java.awt.Dimension;
import java.awt.Color;
import javax.swing.JFrame;

import java.util.List;
import java.util.ArrayList;

public class Pong extends AnimatedJPanel{
  enum Player{left,right};
  Player nextPlayer=Player.left;

  final char leftPlayerKey = 'a';
  final char rightPlayerKey = 'l';
  final char newBallKey = ' ';
  final List<Movable> mvs = new ArrayList<Movable>();
  final Movable leftPaddle = getPaddle(10); 
  final Movable rightPaddle = getPaddle(getWidth()-20); 
  final Movable[] paddles = {leftPaddle,rightPaddle};

  Movable ball = null;

  int leftPoints=0;
  int rightPoints=0;

  Movable getPaddle(int x){return new Paddle(x);}
  Movable getBall(int x,int y){return new Ball(x,y);}

  public Pong(){
    mvs.add(leftPaddle);
    mvs.add(rightPaddle);

    setFocusable(true);
    addKeyListener(new KeyAdapter(){
      public void keyPressed(KeyEvent e){
	if (e.getKeyChar() == leftPlayerKey){
          leftPaddle.setMoveY(Math.abs(leftPaddle.getMoveY()));
        }
        if (e.getKeyChar() == rightPlayerKey){
          rightPaddle.setMoveY(Math.abs(rightPaddle.getMoveY()));
        }
      }
      public void keyReleased(KeyEvent e){ 
        if (e.getKeyChar() == leftPlayerKey){
          leftPaddle.setMoveY(-Math.abs(leftPaddle.getMoveY()));
        } 
        if (e.getKeyChar() == rightPlayerKey){
          rightPaddle.setMoveY(-Math.abs(rightPaddle.getMoveY()));
        }
      }
      public void keyTyped(KeyEvent e){
        if (ball==null && e.getKeyChar() == newBallKey){
          switch (nextPlayer){
            case right: 
      	      ball=getBall(getWidth()-32,rightPaddle.getY()+10);
              ball.setMoveX(-ball.getMoveX());
              break;
            case left: 
              ball=getBall(22,leftPaddle.getY()+10);
              break;
	    }
            mvs.add(ball);
        }
      }
    });
  }

  public void move(){
    rightPaddle.setX(getWidth()-20); 
    if (ball!=null){
      if (ball.above(0) || ball.underneath(getHeight())){
        ball.reverseYDirection();
        ball.move();
      }

      if (ball.leftOf(0) ){
	mvs.remove(ball);
	ball=null;
	rightPoints=rightPoints+1;
	nextPlayer=Player.right;
      }

      else if (ball.rightOf(getWidth()) ){
	mvs.remove(ball);
	ball=null;
	leftPoints=leftPoints+1;
	nextPlayer=Player.left;
      }

      else if (
         (    ball.rightOf(getWidth()-20) 
          && ball.underneath(rightPaddle.getY())
	  && ball.above(rightPaddle.getY()+rightPaddle.getHeight())
         )
         ||
         (    ball.leftOf(20) 
          && ball.underneath(leftPaddle.getY())
	  && ball.above(leftPaddle.getY()+leftPaddle.getHeight())
         )
        )
	ball.reverseXDirection();
    }

    for (Movable mv:mvs) mv.move();
    for (Movable p:paddles){
      if (p.getY()<0) p.setY(0);
      if (p.getY()+p.getHeight()>getHeight()) 
        p.setY(getHeight()-p.getHeight());
    }
  }  

  public void paintComponent(Graphics g){
    g.setColor(Color.GREEN);
    g.fillRect(0,0,getWidth(),getHeight());
    for (Movable mv:mvs) mv.paintMeTo(g);
    g.setColor(Color.BLACK);
    g.drawString(""+leftPoints,40,40);
    g.drawString(""+rightPoints,getWidth()-80,40);
  }

  public Dimension getPreferredSize(){
    return new Dimension(400,300);
  }

  public static void main(String [] _){
    JFrame f = new JFrame("");
    f.getContentPane().add(new Pong());
    f.pack();
    f.setVisible(true);
  }
}

