package name.panitz.games;

import name.panitz.animation.AnimatedJPanel;
import java.awt.Graphics;
import java.awt.Dimension;
import java.awt.Color;
import javax.swing.JFrame;

import java.util.List;
import java.util.ArrayList;
import java.awt.event.*;

public class SimpleAnimation extends  AnimatedJPanel{
  final int width = 400;
  final int height = 300;
  final List<Movable> mvs = new ArrayList<Movable>();
    
  public SimpleAnimation(){
    addMouseListener(new MouseAdapter(){
      public void mouseClicked(MouseEvent me){
        mvs.add(new SimpleMovable());
      } 
    });
  }

  public void move(){
    for (Movable mv:mvs) mv.move();
  }  

  public void paintComponent(Graphics g){
    g.setColor(Color.RED);
    g.fillRect(0,0,width,height);
    for (Movable mv:mvs) mv.paintMeTo(g);
  }

  public Dimension getPreferredSize(){
    return new Dimension(width,height);
  }

  public static void main(String [] _){
    JFrame f = new JFrame("");
    f.getContentPane().add(new SimpleAnimation());
    f.pack();
    f.setVisible(true);
  }
}

