package name.panitz.gui;

import java.io.File;
import java.net.MalformedURLException;

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;

public class ImageIcon extends JLabel {
  private int height = 60;
  private int width = 80;
  final Toolkit toolkit = Toolkit.getDefaultToolkit();
  private Image image;

  public ImageIcon(String fileName){this(new File(fileName));}
  public ImageIcon(final File file){
    setImage(file);
  }

  public void setImage(File jpgFile){
    try{
      image=toolkit.getImage(jpgFile.toURL());
      final MediaTracker tracker = new MediaTracker(this);
      tracker.addImage(image, 0,width,height);
      try {tracker.waitForAll();}
      catch (Exception e) {e.printStackTrace();}
      fitImage();
      setIcon(new javax.swing.ImageIcon(image));
    }catch (MalformedURLException e){}
  }

  private void fitImage(){
    final int w = image.getWidth(this); 
    final int h = image.getHeight(this); 
    
    final int w1 = width;        final int h1 = h*width/w;
    final int w2 = w*height/h;   final int h2 = height;
    final int w3 = w1<w2?w1:w2;  final int h3 = h1<h2?h1:h2;

    image=image.getScaledInstance
                  (w3<w?w3:w,h3<h?h3:h,Image.SCALE_FAST); 
  }
}

