package name.panitz.gui.g2d;
import javax.swing.JPanel;
import javax.swing.JFrame;

import java.awt.font.*;
import java.awt.*;
import java.awt.geom.*;

public class G2DTest extends JPanel{
  int w = 550;
  int h = 650;

  public Dimension getPreferredSize(){
    return new Dimension(w,h);}

  public void paintComponent(Graphics g){
    Graphics2D g2 = (Graphics2D) g;
    TextLayout textTl 
     = new TextLayout
             ("Kommunismus", new Font("Helvetica", 1, 96)
             , new FontRenderContext(null, false, false));

    AffineTransform textAt = new AffineTransform();
    textAt.translate(0,(float)textTl.getBounds().getHeight());
    Shape shape = textTl.getOutline(textAt);

    AffineTransform at = new AffineTransform();
    at.rotate(Math.toRadians(45));
    at.shear(1.5, 0.0);

    g2.transform(at);

    float dash[] = {10.0f};
    g2.setStroke(
      new BasicStroke
           (3.0f, BasicStroke.CAP_BUTT
           ,BasicStroke.JOIN_MITER, 10.0f, dash, 0.0f)
    );

    g2.setPaint(
      new GradientPaint(0,0,Color.black,w,h
                       ,new Color(255,100,100),false)
    );

    g2.fill(shape);
    g2.setColor(Color.darkGray);
    g2.draw(shape);
  }
  
  public static void main(String [] _){
    JFrame f = new JFrame("G2");
    f.getContentPane().add(new G2DTest());
    f.pack();
    f.setVisible(true);
  }
}

