package name.panitz.gui.graphicsFile;

import name.panitz.crempel.tool.apfel.Apfelmaennchen;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.awt.Dimension;
import java.awt.Graphics;

import javax.imageio.ImageIO; 
import javax.swing.JComponent; 

import java.io.File;
import java.io.IOException;

public class ComponentToFile {
  public static void main(String [] args){

   try {
     final JComponent component = new Apfelmaennchen();
     final RenderedImage image = createComponentImage(component);
     ImageIO.write(image,"png", new File(args[0]+".png"));
     ImageIO.write(image,"jpg", new File(args[0]+".jpg"));
    }catch (IOException e) {System.out.println(e);}
  }

  static public RenderedImage createComponentImage
                                (JComponent component) {

     Dimension d = component.getPreferredSize();
     BufferedImage bufferedImage 
      = new BufferedImage((int)d.getWidth(),(int)d.getHeight()
                         ,BufferedImage.TYPE_INT_RGB);

    Graphics g = bufferedImage.createGraphics();

   component.paint(g);

    return bufferedImage;
  }
}

