
package name.panitz.mobile.pong;

import javax.microedition.midlet.*;
import javax.microedition.lcdui.*;

public class MobilePong extends MIDlet implements CommandListener {
  final Display display = Display.getDisplay(this);
  final PongCanvas canvas = new PongCanvas(display);

  private final Command exitCommand
    = new Command("Exit", Command.EXIT, 99);
  private final Command toggleCommand
    = new Command("Stop/Go", Command.SCREEN, 1);
  private final Command helpCommand 
    = new Command("Help", Command.HELP, 2);
  private final Command aboutCommand
    = new Command("About", Command.HELP, 30);

  private final Form helpScreen = new Form("Pong Help");;
  private final String helpText
    = "0 = new ball\n1 = left paddle\n3 = right paddle";

  public  MobilePong() {
    canvas.addCommand(exitCommand);
    canvas.addCommand(toggleCommand);
    canvas.addCommand(helpCommand);
    canvas.addCommand(aboutCommand);
    canvas.setCommandListener(this);

    helpScreen.append("0 = new ball\n");
    helpScreen.append("1 = move left paddle up/down\n");
    helpScreen.append("3 = move right paddle up/down\n");
  }

  public void startApp() throws MIDletStateChangeException {
    canvas.start();
  }
    
  public void pauseApp() {canvas.pause();}

  public void destroyApp(boolean unconditional) 
      throws MIDletStateChangeException {
    canvas.destroy();
  }

  public void commandAction(Command c, Displayable s) {
    final boolean wasPaused = canvas.isPaused();
    canvas.pause();
    if (c == toggleCommand) {if (wasPaused)canvas.start();}
    else if (c == helpCommand) showHelp();
    else if (c == exitCommand) {
      try {
	destroyApp(false);
	notifyDestroyed();
      } catch (MIDletStateChangeException ex) {}
    } else if (c == aboutCommand) About.showAbout(display);
  }

  void showHelp() {
    helpScreen.addCommand(toggleCommand);
    helpScreen.setCommandListener(this);
    display.setCurrent(helpScreen);
  }
}

