
package name.panitz.mobile.pong;

import javax.microedition.lcdui.*;

public class PongCanvas extends Canvas implements Runnable {
  Display display;
  MBall ball=null;
  MPaddle leftPaddle = new MPaddle(10);
  MPaddle rightPaddle= new MPaddle(getWidth()-20);
  final MMovable[] paddles = {leftPaddle,rightPaddle};
  int leftPoints=0;
  int rightPoints=0;
  static final int LEFT_PL=0;
  static final int RIGHT_PL=1;
  int nextPlayer=LEFT_PL;

  boolean paused = false;

  public PongCanvas(Display d) {display = d;}

  final int delay = 20;
  public void run() {
    while (!paused){
      move();
      repaint();
      try {
        Thread.sleep(delay);
      } catch (InterruptedException e) {}
    }
  }

  String msg = null;
  protected void paint(Graphics g) {
    int x = g.getClipX();
    int y = g.getClipY();
    int w = g.getClipWidth();
    int h = g.getClipHeight();

    // Draw the frame 
    g.setColor(0xffffff);
    g.fillRect(x, y, w, h);

    paddles[0].paintMeTo(g);
    paddles[1].paintMeTo(g);
    if (null!=ball) ball.paintMeTo(g);

    g.setColor(0x000000);
    g.drawString(""+leftPoints,30,30,g.TOP|g.LEFT);
    g.drawString(""+rightPoints,getWidth()-30,30,g.TOP|g.RIGHT);


    g.setColor(0);
    g.drawRect(0, 0, getWidth()-1, getHeight()-1);
  }

  public void move(){
    rightPaddle.setX(getWidth()-20); 
    if (ball!=null){
      if (ball.above(0) || ball.underneath(getHeight())){
        ball.reverseYDirection();
        ball.move();
      }

      if (ball.leftOf(0) ){
	ball=null;
	rightPoints=rightPoints+1;
	nextPlayer=RIGHT_PL;
      }

      else if (ball.rightOf(getWidth()) ){
	ball=null;
	leftPoints=leftPoints+1;
	nextPlayer=LEFT_PL;
      }

      else if (
         (    ball.rightOf(getWidth()-20) 
          && ball.underneath(rightPaddle.getY())
	  && ball.above(rightPaddle.getY()+rightPaddle.getHeight())
         )
         ||
         (    ball.leftOf(20) 
          && ball.underneath(leftPaddle.getY())
	  && ball.above(leftPaddle.getY()+leftPaddle.getHeight())
         )
        )
	ball.reverseXDirection();
    }

    paddles[0].move();
    paddles[1].move();
    if (ball!=null) ball.move();
    for (int i=0;i<2;i++){
      if (paddles[i].getY()<0) paddles[i].setY(0);
      if (paddles[i].getY()+paddles[i].getHeight()>getHeight()) 
        paddles[i].setY(getHeight()-paddles[i].getHeight());
    }
  }  

  public void keyReleased(int keyCode) {
    int action = getGameAction(keyCode);
    switch (keyCode) {
      case KEY_NUM1:
        leftPaddle.setMoveY(-Math.abs(leftPaddle.getMoveY()));
	break;

      case KEY_NUM3:
        rightPaddle.setMoveY(-Math.abs(rightPaddle.getMoveY()));
	break;
    }
  }

  public void keyPressed(int keyCode) {
    int action = getGameAction(keyCode);
    switch (keyCode) {
      case KEY_NUM1:
        leftPaddle.setMoveY(Math.abs(leftPaddle.getMoveY()));
	break;
      case KEY_NUM3:
        rightPaddle.setMoveY(Math.abs(rightPaddle.getMoveY()));
	break;
      case KEY_NUM0:
        if (ball==null){
          switch (nextPlayer){
            case RIGHT_PL: 
      	      ball=new MBall(getWidth()-32,rightPaddle.getY()+10);
              ball.setMoveX(-ball.getMoveX());
              break;
            case LEFT_PL: 
              ball=new MBall(22,leftPaddle.getY()+10);
              break;
	    }
        }
	break;
    }
  }

  void destroy() {}

  boolean isPaused() {return paused;}
  void pause() {paused = true;}

  void start() {
    paused = false;
    display.setCurrent(this);
    new Thread(this).start();
  }
}



