package name.panitz.parser;
import java.io.*;
import javax.imageio.ImageIO; 
import javax.swing.*; 
import name.panitz.data.tree.Tree;
import name.panitz.data.tree.DisplayTree;
import static name.panitz.data.tree.TreeToFile.treeToFile;

class ArithParsTreeBuilder{
  
  public static void main(String [] args) throws Exception{
    final String fileName = args[0];
    writeParsTreeFile(new FileReader(fileName+".arith"),fileName);    
  }

  static void writeParsTreeFile(Reader reader,String fileName)
                                               throws Exception{
    treeToFile(parsArith(reader),fileName);            
  }

  public static Tree<String> parsArith(Reader reader) 
                                               throws Exception{
    final ParseResult<Tree<String>> res
     = new TreeArith().parse(ArithTokenizer.tokenize(reader));
    return res.getResult();
  }

  public static DisplayTree parseAndShow(String inp) 
                                      throws Exception{
    return new DisplayTree(parsArith(new StringReader(inp)));
  }

  public static void parseAndShowInFrame(String inp)
                                      throws Exception{
    JComponent c = ArithParsTreeBuilder.parseAndShow(inp);
    JFrame f = new JFrame();
    f.getContentPane().add(c);
    f.pack();
    f.setVisible(true);
  }
}

