package name.panitz.parser;
import java.util.List;
import java.util.ArrayList;
import java.io.Reader;
import java.io.StringReader;
import java.io.IOException;

class ArithTokenizer {

  Reader reader; 
  int next=0;
  List<Token> result = new ArrayList<Token>();

  ArithTokenizer(Reader reader){
    this.reader=reader;
    try {
      next= reader.read();
    }catch (IOException _){}
  }

  List<Token> tokenize() throws Exception{
    try {
      while (next>=0){
        char c = (char)next;
        switch (c){

          case '\u0020'  : break;
          case '\n' : break;
          case '\t' : break;

          case '+'  : result.add(OpToken.add) ; break;
          case '-'  : result.add(OpToken.sub) ; break;
          case '*'  : result.add(OpToken.mult); break;
          case '/'  : result.add(OpToken.div) ; break;

          default   : if (Character.isDigit(c)) {
                        result.add(getInt());
                        continue;
                      }else throw new Exception
                            ("unexpected Token found: '"+c+"'");
        }


        next = reader.read();
      }
    }catch (IOException _){}
    return result;
  }



  Token getInt() throws IOException {
    int res=0;
    while (next>=0 && Character.isDigit((char)next)){
      res=res*10+next-48;
        next = reader.read();
    }
      
    return new Zahl(res);
  }



  static List<Token> tokenize(String inp) throws Exception{
    return tokenize(new StringReader(inp));
  }

  static List<Token> tokenize(Reader inp) throws Exception{
      return new ArithTokenizer(inp).tokenize();
  }
}

