package name.panitz.parser;

import java.util.List;

public class Seq<a,b> implements Parser<Pair<a,b>>{
  final private Parser<a> p1;
  final private Parser<b> p2;
  public Seq(Parser< a> _p1,Parser< b> _p2){p1=_p1;p2=_p2;}

  public ParseResult<Pair<a,b>> parse(List<Token> ts){
    ParseResult<a> r1 = p1.parse(ts);

    if (r1.failed()) return new ParseResult<Pair<a,b>>(null,ts);

    ParseResult<b> r2 = p2.parse(r1.getRemainingToken());

    if (r2.failed()) return new ParseResult<Pair<a,b>>(null,ts);

    return new ParseResult<Pair<a,b>>
                 (new Pair<a,b>(r1.getResult(),r2.getResult())
                 ,r2.getRemainingToken());
  }
}

